/*
 * Decompiled with CFR 0.152.
 */
package cn.tenmg.dsl.utils;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public abstract class MapUtils {
    public static boolean isEmpty(Map<?, ?> m) {
        return m == null || m.isEmpty();
    }

    public static boolean isNotEmpty(Map<?, ?> m) {
        return m != null && !m.isEmpty();
    }

    public static <K> void removeAll(Map<K, ?> map, Set<K> keys) {
        Iterator<K> it = keys.iterator();
        while (it.hasNext()) {
            map.remove(it.next());
        }
    }

    public static <K, V> HashMap<K, V> newHashMap() {
        return new HashMap();
    }

    public static <K, V> HashMap<K, V> newHashMap(int initialCapacity) {
        return new HashMap(initialCapacity);
    }

    public static <K, V> HashMap<K, V> newHashMap(K key, V value) {
        HashMap<K, V> map = new HashMap<K, V>();
        map.put(key, value);
        return map;
    }

    public static <K, V> HashMap<K, V> newHashMap(int initialCapacity, K key, V value) {
        HashMap<K, V> map = new HashMap<K, V>(initialCapacity);
        map.put(key, value);
        return map;
    }

    public static <K, V> ConcurrentHashMap<K, V> newConcurrentHashMap() {
        return new ConcurrentHashMap();
    }

    public static <K, V> ConcurrentHashMap<K, V> newConcurrentHashMap(int initialCapacity) {
        return new ConcurrentHashMap(initialCapacity);
    }

    public static <K, V> ConcurrentHashMap<K, V> newConcurrentHashMap(K key, V value) {
        ConcurrentHashMap<K, V> map = new ConcurrentHashMap<K, V>();
        map.put(key, value);
        return map;
    }

    public static <K, V> ConcurrentHashMap<K, V> newConcurrentHashMap(int initialCapacity, K key, V value) {
        ConcurrentHashMap<K, V> map = new ConcurrentHashMap<K, V>(initialCapacity);
        map.put(key, value);
        return map;
    }

    public static <K, V> HashMap<K, V> toHashMap(Map<K, V> map) {
        HashMap<K, V> copy = new HashMap<K, V>(map.size());
        copy.putAll(map);
        return copy;
    }

    public static <K, V> ConcurrentHashMap<K, V> toConcurrentHashMap(Map<K, V> map) {
        ConcurrentHashMap<K, V> copy = new ConcurrentHashMap<K, V>(map.size());
        copy.putAll(map);
        return copy;
    }

    public static <M extends Map<K, V>, K, V> MapBuilder<M, K, V> newMapBuilder(M map) {
        return new MapBuilder(map);
    }

    public static <K, V> MapBuilder<HashMap<K, V>, K, V> newHashMapBuilder(K key, V value) {
        return new MapBuilder(MapUtils.newHashMap(key, value));
    }

    public static <K, V> MapBuilder<HashMap<K, V>, K, V> newHashMapBuilder(int initialCapacity, K key, V value) {
        return new MapBuilder(MapUtils.newHashMap(initialCapacity, key, value));
    }

    public static <K, V> MapBuilder<HashMap<K, V>, K, V> newHashMapBuilder() {
        return new MapBuilder(MapUtils.newHashMap());
    }

    public static <K, V> MapBuilder<HashMap<K, V>, K, V> newHashMapBuilder(int initialCapacity) {
        return new MapBuilder(MapUtils.newHashMap(initialCapacity));
    }

    public static <K, V> MapBuilder<HashMap<K, V>, K, V> newHashMapBuilder(Class<K> keyType) {
        return new MapBuilder(MapUtils.newHashMap());
    }

    public static <K, V> MapBuilder<HashMap<K, V>, K, V> newHashMapBuilder(int initialCapacity, Class<K> keyType) {
        return new MapBuilder(MapUtils.newHashMap(initialCapacity));
    }

    public static <K, V> MapBuilder<HashMap<K, V>, K, V> newHashMapBuilder(Class<K> keyType, Class<V> valueType) {
        return new MapBuilder(MapUtils.newHashMap());
    }

    public static <K, V> MapBuilder<HashMap<K, V>, K, V> newHashMapBuilder(int initialCapacity, Class<K> keyType, Class<V> valueType) {
        return new MapBuilder(MapUtils.newHashMap(initialCapacity));
    }

    public static <K, V> MapBuilder<ConcurrentHashMap<K, V>, K, V> newConcurrentHashMapBuilder(K key, V value) {
        return new MapBuilder(MapUtils.newConcurrentHashMap(key, value));
    }

    public static <K, V> MapBuilder<ConcurrentHashMap<K, V>, K, V> newConcurrentHashMapBuilder(int initialCapacity, K key, V value) {
        return new MapBuilder(MapUtils.newConcurrentHashMap(initialCapacity, key, value));
    }

    public static <K, V> MapBuilder<ConcurrentHashMap<K, V>, K, V> newConcurrentHashMapBuilder() {
        return new MapBuilder(MapUtils.newConcurrentHashMap());
    }

    public static <K, V> MapBuilder<ConcurrentHashMap<K, V>, K, V> newConcurrentHashMapBuilder(int initialCapacity) {
        return new MapBuilder(MapUtils.newConcurrentHashMap(initialCapacity));
    }

    public static <K, V> MapBuilder<ConcurrentHashMap<K, V>, K, V> newConcurrentHashMapBuilder(Class<K> keyType) {
        return new MapBuilder(MapUtils.newConcurrentHashMap());
    }

    public static <K, V> MapBuilder<ConcurrentHashMap<K, V>, K, V> newConcurrentHashMapBuilder(int initialCapacity, Class<K> keyType) {
        return new MapBuilder(MapUtils.newConcurrentHashMap(initialCapacity));
    }

    public static <K, V> MapBuilder<ConcurrentHashMap<K, V>, K, V> newConcurrentHashMapBuilder(Class<K> keyType, Class<V> valueType) {
        return new MapBuilder(MapUtils.newConcurrentHashMap());
    }

    public static <K, V> MapBuilder<ConcurrentHashMap<K, V>, K, V> newConcurrentHashMapBuilder(int initialCapacity, Class<K> keyType, Class<V> valueType) {
        return new MapBuilder(MapUtils.newConcurrentHashMap(initialCapacity));
    }

    public static <K, V> MapBuilder<HashMap<K, V>, K, V> toHashMapBuilder(Map<K, V> map) {
        HashMap<K, V> copy = new HashMap<K, V>(map.size());
        copy.putAll(map);
        return new MapBuilder(copy);
    }

    public static <K, V> MapBuilder<ConcurrentHashMap<K, V>, K, V> toConcurrentHashMapBuilder(Map<K, V> map) {
        ConcurrentHashMap<K, V> copy = new ConcurrentHashMap<K, V>(map.size());
        copy.putAll(map);
        return new MapBuilder(copy);
    }

    public static class MapBuilder<M extends Map<K, V>, K, V> {
        private final M map;

        public MapBuilder(M map) {
            this.map = map;
        }

        public MapBuilder<M, K, V> putAll(Map<K, V> map) {
            if (map != null) {
                this.map.putAll(map);
            }
            return this;
        }

        public MapBuilder<M, K, V> put(K key, V value) {
            this.map.put(key, value);
            return this;
        }

        public M build() {
            return this.map;
        }

        public M build(K key, V value) {
            this.map.put(key, value);
            return this.map;
        }

        public M build(Map<K, V> map) {
            this.map.putAll(map);
            return this.map;
        }
    }
}

