/*
 * Decompiled with CFR 0.152.
 */
package cn.tenmg.dsl.utils;

import cn.tenmg.dsl.utils.ClassUtils;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;

public abstract class FileUtils {
    private static final String JAR = "jar";
    private static final boolean isWindows = System.getProperty("os.name", "").toLowerCase().contains("windows");

    private FileUtils() {
    }

    public static List<String> scanPackage(String basePackage, String suffix) throws IOException {
        return FileUtils.scanPackage(ClassUtils.getDefaultClassLoader(), basePackage, suffix);
    }

    public static List<String> scanPackage(ClassLoader classLoader, String basePackage, String suffix) throws IOException {
        Enumeration<URL> urls = classLoader.getResources(basePackage = basePackage.replaceAll("\\.", "/"));
        if (urls != null) {
            ArrayList<String> fileNames = new ArrayList<String>();
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                if (url.getProtocol().equals(JAR)) {
                    Enumeration<JarEntry> entries = ((JarURLConnection)url.openConnection()).getJarFile().entries();
                    while (entries.hasMoreElements()) {
                        String name = entries.nextElement().getName();
                        if (!name.endsWith(suffix)) continue;
                        fileNames.add(name);
                    }
                    continue;
                }
                if (!url.getProtocol().equals("file")) continue;
                String path = url.getPath();
                if (isWindows && path.startsWith("/")) {
                    path = path.substring(1);
                }
                fileNames.addAll(FileUtils.walkFileTree(Paths.get(path, new String[0]), Paths.get(path.substring(0, path.lastIndexOf(basePackage)), new String[0]).toString(), suffix));
            }
            return fileNames;
        }
        return null;
    }

    private static List<String> walkFileTree(Path path, final String basePath, final String suffix) throws IOException {
        final ArrayList<String> result = new ArrayList<String>();
        Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) throws IOException {
                if (path.toString().endsWith(suffix)) {
                    result.add(path.toString().replace(basePath, "").substring(1).replace("\\", "/"));
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult preVisitDirectory(Path path, BasicFileAttributes attrs) throws IOException {
                return FileVisitResult.CONTINUE;
            }
        });
        return result;
    }
}

