/*
 * Decompiled with CFR 0.152.
 */
package cn.tenmg.dsl.utils;

import cn.tenmg.dsl.utils.PlaceHolderUtils;
import cn.tenmg.dsl.utils.PropertiesLoaderUtils;
import java.util.Map;
import java.util.Properties;

public abstract class ConfigUtils {
    private static final String DEFAULT_STRATEGIES_PATH = "dsl-config-loader.properties";
    private static final String CONFIG_LOCATION_KEY = "config.location";
    private static Properties configProperties = new Properties();

    private ConfigUtils() {
    }

    public static String getProperty(String key) {
        return configProperties.getProperty(key);
    }

    public static String getProperty(String key, String defaultValue) {
        return configProperties.getProperty(key, defaultValue);
    }

    private static void loadConfig() {
        PropertiesLoaderUtils.loadIgnoreException(configProperties, DEFAULT_STRATEGIES_PATH);
        PropertiesLoaderUtils.loadIgnoreException(configProperties, "dsl-default.properties");
        PropertiesLoaderUtils.loadIgnoreException(configProperties, configProperties.getProperty(CONFIG_LOCATION_KEY, "dsl.properties"));
    }

    private static void replacePlaceHolder() {
        for (Map.Entry<Object, Object> entry : configProperties.entrySet()) {
            Object value = entry.getValue();
            configProperties.put(entry.getKey(), value == null ? null : PlaceHolderUtils.replace(value.toString(), configProperties));
        }
    }

    static {
        ConfigUtils.loadConfig();
        ConfigUtils.replacePlaceHolder();
    }
}

