/*
 * Decompiled with CFR 0.152.
 */
package cn.tenmg.dsl.converter;

import cn.tenmg.dsl.converter.FormatableParamsConverter;
import cn.tenmg.dsl.utils.DateUtils;
import cn.tenmg.dsl.utils.DecimalUtils;
import java.util.Calendar;
import java.util.Date;

public class ToStringParamsConverter
extends FormatableParamsConverter<String> {
    @Override
    public String convert(Object value) {
        if (value == null) {
            return null;
        }
        String formatter = this.getFormatter();
        if (formatter != null) {
            if (value instanceof Number) {
                return DecimalUtils.format(value, formatter);
            }
            if (value instanceof Date) {
                return DateUtils.format(value, formatter);
            }
            if (value instanceof Calendar) {
                return DateUtils.format(((Calendar)value).getTime(), formatter);
            }
        }
        return value.toString();
    }
}

