package cn.tenfell.tools.nocontroller.component;

import cn.tenfell.tools.nocontroller.annotation.NeedLogin;
import cn.tenfell.tools.nocontroller.inface.NoControllerInterface;
import cn.tenfell.tools.nocontroller.utils.AopTargetUtils;
import cn.tenfell.tools.nocontroller.utils.ToolsUtils;
import cn.tenfell.tools.nocontroller.utilsentity.PoData;
import cn.tenfell.tools.nocontroller.utilsentity.ServiceCacheData;
import cn.tenfell.tools.nocontroller.utilsentity.UriMap;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.lang.reflect.Method;
import java.util.*;

@Component
public class UriHandComponent implements ApplicationContextAware {
    public static Map<String, UriMap> handMap = new HashMap<String,UriMap>();
    public static NoControllerInterface noControllerInterface;
    @Autowired
    NoControllerInterface noControllerInterfaceService;
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        UriHandComponent.noControllerInterface = noControllerInterfaceService;
        String[] conMappings = {"json","jsonp"};
        Map<String, Object> serviceMap =  applicationContext.getBeansWithAnnotation(Service.class);
        Set<String> keys = serviceMap.keySet();
        List<ServiceCacheData> serviceCacheDataList = new ArrayList<ServiceCacheData>();
        for(String key:keys){
            //代理对象,用于事务控制
            Object service = serviceMap.get(key);
            //原对象,用于获取注解
            Object serviceTarget = AopTargetUtils.getTarget(service);
            ServiceCacheData serviceCacheData = new ServiceCacheData();
            serviceCacheData.setService(serviceTarget);
            serviceCacheData.setServiceName(key);
            List<Method> methodList = new ArrayList<Method>();
            Method[] methods = serviceTarget.getClass().getDeclaredMethods();
            for(Method method:methods){
                Class<?>[] types = method.getParameterTypes();
                boolean hasMethod = false;
                if((types.length == 1 || types.length == 2) && types[0] == PoData.class){
                    hasMethod = true;
                    //表示要处理的json,jsonp
                    UriMap uriMap = new UriMap();
                    uriMap.setService(service);
                    uriMap.setMethod(method);
                    uriMap.setParams(types);
                    NeedLogin needLogin = method.getAnnotation(NeedLogin.class);
                    uriMap.setNeedLogin(needLogin != null);
                    for(String conMapping:conMappings){
                        String mapKey = "/"+conMapping+"/"+key+"/"+method.getName();
                        handMap.put(mapKey,uriMap);
                    }
                }else if((types.length == 2 || types.length == 3) && types[0] == HttpServletRequest.class && types[1] == HttpServletResponse.class){
                    hasMethod = true;
                    //表示要处理的selevt
                    UriMap uriMap = new UriMap();
                    uriMap.setService(service);
                    uriMap.setMethod(method);
                    uriMap.setParams(types);
                    NeedLogin needLogin = method.getAnnotation(NeedLogin.class);
                    uriMap.setNeedLogin(needLogin != null);
                    String mapKey = "/selevt/"+key+"/"+method.getName();
                    handMap.put(mapKey,uriMap);
                }
                if(hasMethod){
                    methodList.add(method);
                }
            }
            serviceCacheData.setMethods(methodList);
            serviceCacheDataList.add(serviceCacheData);
        }
        ToolsUtils.setInterfaceList(serviceCacheDataList);
    }
}

