package cn.tenfell.tools.nocontroller.utilsentity;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.lang.Dict;
import cn.hutool.core.util.ObjectUtil;
import java.util.Date;
public class PoData extends Dict{
    private static final long serialVersionUID = 1L;
    public static PoData create() {
        return new PoData();
    }
    public PoData set(String attr, Object value) {
        super.set(attr,value);
        return this;
    }
    public static <T> PoData parse(T bean) {
        return create().parseBean(bean);
    }
    public <T> PoData parseBean(T bean) {
        super.parseBean(bean);
        return this;
    }
    @Override
    public PoData clone() {
        return (PoData)super.clone();
    }
    public PoData filter(String... keys) {
        final PoData result = PoData.create();
        for (String key : keys) {
            if (this.containsKey(key)) {
                result.put(key, this.get(key));
            }
        }
        return result;
    }
    public <T> PoData parseBean(T bean, boolean isToUnderlineCase, boolean ignoreNullValue) {
        super.parseBean(bean,isToUnderlineCase,ignoreNullValue);
        return this;
    }
    public PoData setIgnoreNull(String attr, Object value) {
        super.setIgnoreNull(attr,value);
        return this;
    }
    public DateTime getDateTime(String attr){
        Object obj = this.get(attr);
        if(ObjectUtil.isNull(obj)){
            return null;
        }
        if(obj instanceof DateTime){
            return (DateTime)obj;
        }
        if(obj instanceof Date){
            return new DateTime(this.getDate(attr));
        }
        if(obj instanceof String){
            return DateUtil.parse(this.getStr(attr));
        }
        Assert.isTrue(false, String.format("%s cannot be cast to cn.hutool.core.date.DateTime", obj.getClass().toString()));
        return null;
    }
}
