package cn.tenfell.tools.nocontroller.utils;

import cn.hutool.core.exceptions.ExceptionUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.servlet.ServletUtil;
import cn.hutool.json.JSONUtil;
import cn.tenfell.tools.nocontroller.annotation.InterfaceDoc;
import cn.tenfell.tools.nocontroller.annotation.InterfaceModule;
import cn.tenfell.tools.nocontroller.utilsentity.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class ToolsUtils {
    public static List<InterfaceDocEntity> interfaceList = new ArrayList<InterfaceDocEntity>();
    public static String interfaceCreateTime;
    public static void setInterfaceList(List<ServiceCacheData> list){
        String[] conMappings = {"json","jsonp"};
        for(ServiceCacheData serviceCacheData:list){
            InterfaceDocEntity interfaceDocEntity = null;
            List<InterfaceDocChild> interfaceDocChildren = null;
            Object service = serviceCacheData.getService();
            List<Method> methodList = serviceCacheData.getMethods();
            for(Method method:methodList){
                Class<?>[] types = method.getParameterTypes();
                InterfaceDoc interfaceDoc = method.getAnnotation(InterfaceDoc.class);
                boolean hasDoc = interfaceDoc != null && (types.length == 1 && types[0] == PoData.class) || (types.length == 2 && types[0] == HttpServletRequest.class && types[1] == HttpServletResponse.class);
                if(!hasDoc){
                    continue;
                }
                if(interfaceDocEntity == null){
                    interfaceDocEntity = new InterfaceDocEntity();
                    interfaceDocChildren = new ArrayList<InterfaceDocChild>();
                    String moduleName = serviceCacheData.getServiceName();
                    InterfaceModule interfaceModule = service.getClass().getAnnotation(InterfaceModule.class);
                    if(interfaceModule != null && !"".equals(interfaceModule.value())){
                        moduleName = interfaceModule.value();
                    }
                    interfaceDocEntity.setName(moduleName);
                }
                InterfaceDocChild interfaceDocChild = new InterfaceDocChild();
                try{
                    Object returnObj = method.getReturnType().newInstance();
                    interfaceDocChild.setReturnData(JSONUtil.toJsonStr(returnObj));
                }catch (Exception e){
                }
                String interfaceName = method.getName();
                if(interfaceDoc != null && !"".equals(interfaceDoc.name())){
                    interfaceName = interfaceDoc.name();
                }
                interfaceDocChild.setName(interfaceName);
                List<InterfaceParams> interfaceParamsList = new ArrayList<InterfaceParams>();
                String[] params = interfaceDoc.params();
                for(String param:params){
                    if(param == null || "".equals(param.trim())){
                        continue;
                    }
                    String[] paramValues = param.split(interfaceDoc.separator(),3);
                    if(paramValues.length != 3){
                        continue;
                    }
                    InterfaceParams interfaceParams = new InterfaceParams();
                    interfaceParams.setParam(paramValues[0]);
                    interfaceParams.setIsNeed(paramValues[1]);
                    interfaceParams.setParamDesc(paramValues[2]);
                    interfaceParamsList.add(interfaceParams);
                }
                interfaceDocChild.setParams(interfaceParamsList);
                List<String> urlList = new ArrayList<String>();
                if(types.length == 1 && types[0] == PoData.class){
                    //表示要处理的json,jsonp
                    for(String conMapping:conMappings){
                        String mapKey = "/"+conMapping+"/"+serviceCacheData.getServiceName()+"/"+method.getName();
                        urlList.add(mapKey);
                    }
                }else if(types.length == 2 && types[0] == HttpServletRequest.class && types[1] == HttpServletResponse.class){
                    //表示要处理的selevt
                    String mapKey = "/selevt/"+serviceCacheData.getServiceName()+"/"+method.getName();
                    urlList.add(mapKey);
                }
                interfaceDocChild.setUrlList(urlList);
                interfaceDocChildren.add(interfaceDocChild);
            }
            if(interfaceDocEntity != null){
                interfaceDocEntity.setList(interfaceDocChildren);
                interfaceList.add(interfaceDocEntity);
            }
        }
        interfaceCreateTime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date());
    }
    public static String getExceptionMessage(Throwable e,boolean isAll) {
        String msg;
        Throwable temp = ExceptionUtil.getRootCause(e);
        if(isAll){
            msg = ExceptionUtil.stacktraceToString(temp);
        }else{
            msg = temp.getMessage();
        }
        return msg;
    }
    public static PoData readRequestData(HttpServletRequest request){
        PoData poData = PoData.create();
        String requestBody = ServletUtil.getBody(request);
        poData.putAll(ServletUtil.getParamMap(request));
        if(StrUtil.isNotBlank(requestBody)){
            poData.put("requestBody",requestBody);
        }
        return poData;
    }
    public static <T> T dataToBean(PoData data,Class clazz){
        try{
            String requestBody = data.getStr("requestBody");
            if(StrUtil.isNotBlank(requestBody)){
                data = JSONUtil.parseObj(requestBody).toBean(PoData.class);
            }
            return (T)data.toBean(clazz);
        }catch (Exception e){
            return null;
        }
    }
}
