package cn.tenfell.tools.nocontroller.utilsentity;
import cn.tenfell.tools.nocontroller.utils.ToolsUtils;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class PoData extends HashMap<String,Object> implements Map<String,Object>{
    private Object user;
    private static final long serialVersionUID = 1L;
    private static Map<String,SimpleDateFormat> sdfMap = new HashMap<String,SimpleDateFormat>();
    public PoData add(String key,Object val){
        this.put(key,val);
        return this;
    }
    public Double getDouble(String key) {
        return this.getT(key,Double.class);
    }
    public double getdouble(String key) {
        return this.getT(key,double.class);
    }
    public Integer getInteger(String key) {
        return this.getT(key,Integer.class);
    }
    public int getInt(String key) {
        return this.getT(key,int.class);
    }
    public Long getLong(String key) {
        return this.getT(key,Long.class);
    }
    public long getlong(String key) {
        return this.getT(key,long.class);
    }
    public Boolean getBoolean(String key) {
        return this.getT(key,Boolean.class);
    }
    public boolean getboolean(String key) {
        return this.getT(key,boolean.class);
    }
    public String getString(String key) {
        return this.getT(key,String.class);
    }
    public Date getDate(String key) {
        return this.getT(key,Date.class);
    }
    private <T> T getT(String key,Class clazz){
        Object val = this.get(key);
        if(val == null || "".equals(val.toString())){
            if(clazz == byte.class){
                val = (byte)0;
            }else if(clazz == short.class){
                val = (short)0;
            }else if(clazz == int.class){
                val = 0;
            }else if(clazz == long.class){
                val = (long)0;
            }else if(clazz == float.class){
                val = (float)0;
            }else if(clazz == double.class){
                val =(double)0;
            }else if(clazz == boolean.class){
                val = false;
            }else if(clazz == char.class){
                val = (char)0;
            }
            if(val != null){
                return (T)val;
            }
            return null;
        }
        if(clazz == Byte.class || clazz == byte.class){
            Object num;
            if(val instanceof Number){
                num = ((Number)val).byteValue();
            }else{
                num = Byte.parseByte(val.toString());
            }
            return (T)num;
        }else if(clazz == Short.class || clazz == short.class){
            Object num;
            if(val instanceof Number){
                num = ((Number)val).shortValue();
            }else{
                num = Short.parseShort(val.toString());
            }
            return (T)num;
        }else if(clazz == Integer.class || clazz == int.class){
            Object num;
            if(val instanceof Number){
                num = ((Number)val).intValue();
            }else{
                num = Integer.parseInt(val.toString());
            }
            return (T)num;
        }else if(clazz == Long.class || clazz == long.class){
            Object num;
            if(val instanceof Number){
                num = ((Number)val).longValue();
            }else{
                num = Long.parseLong(val.toString());
            }
            return (T)num;
        }else if(clazz == Float.class || clazz == float.class){
            Object num;
            if(val instanceof Number){
                num = ((Number)val).floatValue();
            }else{
                num = Float.parseFloat(val.toString());
            }
            return (T)num;
        }else if(clazz == Double.class || clazz == double.class){
            Object num;
            if(val instanceof Number){
                num = ((Number)val).doubleValue();
            }else{
                num = Double.parseDouble(val.toString());
            }
            return (T)num;
        }else if(clazz == Boolean.class || clazz == boolean.class){
            Object flag = null;
            if (val.equals(Boolean.FALSE) || val instanceof String && val.toString().equalsIgnoreCase("false")) {
                flag = false;
            }
            if (val.equals(Boolean.TRUE) || val instanceof String && val.toString().equalsIgnoreCase("true")) {
                flag = true;
            }
            if(flag != null){
                return (T)flag;
            }
            throw new RuntimeException(key+"="+val.toString()+" is not a boolean");
        }else if(clazz == Character.class || clazz == char.class){
            return (T)val;
        }else if(clazz == Date.class){
            if(val instanceof Date){
                return (T)val;
            }else{
                SimpleDateFormat sdf1 = PoData.sdfMap.get("yyyy-MM-dd HH:mm:ss");
                if(sdf1 == null){
                    sdf1 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    PoData.sdfMap.put("yyyy-MM-dd HH:mm:ss",sdf1);
                }
                try{
                    Object datetime = sdf1.parse(val.toString());
                    return (T)datetime;
                }catch (Exception e){
                    SimpleDateFormat sdf2 = PoData.sdfMap.get("yyyy-MM-dd");
                    if(sdf2 == null){
                        sdf2 = new SimpleDateFormat("yyyy-MM-dd");
                        PoData.sdfMap.put("yyyy-MM-dd",sdf2);
                    }
                    try{
                        Object date = sdf2.parse(val.toString());
                        return (T)date;
                    }catch (Exception e2){
                        SimpleDateFormat sdf3 = PoData.sdfMap.get("HH:mm:ss");
                        if(sdf3 == null){
                            sdf3 = new SimpleDateFormat("HH:mm:ss");
                            PoData.sdfMap.put("HH:mm:ss",sdf3);
                        }
                        try{
                            Object time = sdf3.parse(val.toString());
                            return (T)time;
                        }catch (Exception e3){
                            throw new RuntimeException(key+"="+val.toString()+" is not a timestr");
                        }
                    }
                }
            }
        }else if(clazz == String.class){
            return (T)(val.toString());
        }else if(clazz == BigDecimal.class){
            BigDecimal bigDecimal = new BigDecimal(val.toString());
            return (T)(bigDecimal);
        }else{
            return (T)val;
        }
    }
    public <T> T conversion(Class clazz){
        PoData poData = this;
        if(poData == null) {
            return null;
        }
        T obj;
        try {
            obj = (T)clazz.newInstance();
            Field[] fields = clazz.getDeclaredFields();
            for (Field field : fields) {
                int mod = field.getModifiers();
                if (Modifier.isStatic(mod) || Modifier.isFinal(mod)) {
                    continue;
                }
                field.setAccessible(true);
                Class<?> type = field.getType();
                Object value = poData.getT(field.getName(),type);;
                if(value != null){
                    field.set(obj, value);
                }
            }
        } catch (Exception e) {
            throw new RuntimeException("this object can not cast to"+clazz.getName());
        }
        return obj;
    }
    public <T> T getUser() {
        return (T)user;
    }
    public void setUser(Object user) {
        this.user = user;
    }
    public String toJsonString(){
        return ToolsUtils.toJsonString(this);
    }
    public static PoData unConversion(Object object){
        PoData poData = new PoData();
        try{
            Field[] fields = object.getClass().getDeclaredFields();
            for (Field field : fields) {
                field.setAccessible(true);
                Object value = field.get(object);
                poData.put(field.getName(),value);
            }
        }catch (Exception e){
            e.printStackTrace();
            poData = null;
        }
        return poData;
    }
}
