package cn.tenfell.tools.nocontroller.filter;
import cn.tenfell.tools.nocontroller.config.NoControllerConfiguration;
import cn.tenfell.tools.nocontroller.utils.ToolsUtils;
import org.springframework.lang.Nullable;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;
import cn.tenfell.tools.nocontroller.component.UriHandComponent;
import cn.tenfell.tools.nocontroller.utilsentity.UriMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
public class LoginHandlerInterceptor implements HandlerInterceptor {
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler){
        UriMap uriMap = UriHandComponent.handMap.get(request.getRequestURI());
        if(uriMap == null){
            //说明接口不存在
            if("/interface/doclist".equals(request.getRequestURI())){
                return true;
            }
            try{
                Object noMethod = UriHandComponent.noControllerInterface.noMethod(request);
                response.setContentType("application/json;charset=UTF-8");
                response.getOutputStream().write(ToolsUtils.toJsonString(noMethod).getBytes());
            }catch (Exception e){
                e.printStackTrace();
            }
            return false;
        }
        if(uriMap.isNeedLogin()){
            //说明此接口需要登录
            Object user = UriHandComponent.noControllerInterface.getLoginUser(request);
            if(user == null){
                try{
                    Object noLogin = UriHandComponent.noControllerInterface.noLogin(request);
                    response.setContentType("application/json;charset=UTF-8");
                    response.getOutputStream().write(ToolsUtils.toJsonString(noLogin).getBytes());
                }catch (Exception e){
                    e.printStackTrace();
                }
                return false;
            }
        }
        return true;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, @Nullable ModelAndView modelAndView) throws Exception {
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, @Nullable Exception ex) throws Exception {
    }
}
