package cn.tenfell.tools.nocontroller.controller;

import cn.tenfell.tools.nocontroller.component.UriHandComponent;
import cn.tenfell.tools.nocontroller.config.NoControllerConfiguration;
import cn.tenfell.tools.nocontroller.inface.NoControllerInterface;
import cn.tenfell.tools.nocontroller.utils.ToolsUtils;
import cn.tenfell.tools.nocontroller.utilsentity.PoData;
import cn.tenfell.tools.nocontroller.utilsentity.UriMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.BufferedReader;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.Map;
@Controller
public class WebController {
    public static Logger Logger = LoggerFactory.getLogger(WebController.class);
    @Autowired
    ApplicationContext ac;
    @Autowired
    NoControllerInterface noControllerInterface;
    @RequestMapping(value = "/selevt/{1}/{2}")
    public void selevt(HttpServletRequest request, HttpServletResponse response) throws Exception{
        Exception throwException = null;
        try {
            UriMap uriMap= UriHandComponent.handMap.get(request.getRequestURI());
            uriMap.getMethod().invoke(uriMap.getService(),request,response);
        } catch (Exception e) {
            throwException = e;
        }
        if(throwException != null){
            Logger.error(getExceptionAllinformation(throwException,false),throwException);
            throwException.printStackTrace();
            throw throwException;
        }
    }
    @RequestMapping(value = "/json/{1}/{2}", produces = MediaType.APPLICATION_JSON_VALUE)
    @ResponseBody
    public Object json(HttpServletRequest request){
        Object result = actionAjax(request,"json");
        return result;
    }
    @RequestMapping(value = "/jsonp/{1}/{2}", produces = MediaType.APPLICATION_JSON_VALUE)
    @ResponseBody
    public String jsonp(HttpServletRequest request){
        Object result = actionAjax(request,"jsonp");
        String callback = request.getParameter("callback");
        if(callback == null || "".equals(callback)){
            callback = "callback";
        }
        return callback+"("+ ToolsUtils.toJsonString(result) +")";
    }
    private static String readRequestBodyAsChars(HttpServletRequest request){
        BufferedReader br = null;
        StringBuilder sb = new StringBuilder();
        try{
            br = request.getReader();
            String str;
            while ((str = br.readLine()) != null){
                sb.append(str);
            }
            br.close();
        }catch (IOException e){
            e.printStackTrace();
        }finally{
            if (null != br){
                try{
                    br.close();
                }catch (IOException e){
                    e.printStackTrace();
                }
            }
        }
        return sb.toString();
    }
    private static PoData readRequestData(HttpServletRequest request){
        Map properties = request.getParameterMap();
        PoData poData = new PoData();
        Iterator entries = properties.entrySet().iterator();
        Map.Entry entry;
        String name = "";
        String value = "";
        while (entries.hasNext()) {
            entry = (Map.Entry) entries.next();
            name = (String) entry.getKey();
            Object valueObj = entry.getValue();
            if (null == valueObj) {
                value = "";
            } else if (valueObj instanceof String[]) {
                String[] values = (String[]) valueObj;
                for (int i = 0; i < values.length; i++) {
                    value = values[i] + ",";
                }
                value = value.substring(0, value.length() - 1);
            } else {
                value = valueObj.toString().trim();
            }
            poData.put(name.trim(), value.trim());
        }
        String requestBody = readRequestBodyAsChars(request);
        if(!ToolsUtils.isEmpty(requestBody)){
            poData.put("requestBody",requestBody);
        }
        return poData;
    }
    private Object actionAjax(HttpServletRequest request,String type){
        PoData poData = readRequestData(request);
        if(ToolsUtils.equals(type,"jsonp")){
            poData.remove("callback");
        }
        Object result = null;
        try {
            addSomeToParam(request, poData);
            UriMap uriMap= UriHandComponent.handMap.get(request.getRequestURI());
            result =uriMap.getMethod().invoke(uriMap.getService(),poData);
        } catch (Exception e) {
            result = errorReturn(e);
        }
        return result;
    }
    private Object errorReturn(Exception e){
        String error = getExceptionAllinformation(e,true);
        String msg = getExceptionAllinformation(e,false);
        Logger.error(msg,e);
        return noControllerInterface.errorReturn(e,msg,error);
    }
    public static String getExceptionAllinformation(Exception e,boolean isAll) {
        if(isAll){
            //获取全部异常,供开发者调试
            StringBuffer stringBuffer =new StringBuffer();
            if(e.getMessage() != null){
                stringBuffer.append(e.getMessage());
                stringBuffer.append(";");
            }
            if(e.getCause() != null){
                stringBuffer.append(e.getCause().toString()+";");
            }
            StackTraceElement [] stes;
            try{
                //拿到反射调方法的内部异常
                stes=((InvocationTargetException)e).getTargetException().getStackTrace();
            }catch (Exception e2){
                //当拿不到内部异常的时候,拿本类异常
                stes=e.getStackTrace();
            }
            if(stes!=null && stes.length>0){
                for(StackTraceElement ste:stes){
                    stringBuffer.append(ste.toString()+";");
                }
            }
            return stringBuffer.toString();
        }else{
            //获取异常Message,给用户显示
            try{
                //读取反射异常
                return ((InvocationTargetException) e).getTargetException().getCause().getMessage();
            }catch (Exception e1){
                //反射异常读取失败,读取原异常
                return e.getMessage();
            }
        }
    }
    @RequestMapping(value = "/interface/doclist", produces = MediaType.APPLICATION_JSON_VALUE)
    @ResponseBody
    public PoData doclist(HttpServletRequest request){
        PoData poData = new PoData();
        if("".equals(NoControllerConfiguration.key)){
            poData.put("flag",true);
            poData.put("list",ToolsUtils.interfaceList);
            poData.put("time",ToolsUtils.interfaceCreateTime);
            return poData;
        }
        if(request.getParameter("key") == null || "".equals(request.getParameter("key"))){
            poData.put("flag",false);
            poData.put("msg","请输入密钥");
            return poData;
        }
        if(!NoControllerConfiguration.key.equals(request.getParameter("key"))){
            poData.put("flag",false);
            poData.put("msg","密钥错误");
            return poData;
        }
        poData.put("flag",true);
        poData.put("list",ToolsUtils.interfaceList);
        poData.put("time",ToolsUtils.interfaceCreateTime);
        return poData;
    }
    public void addSomeToParam(HttpServletRequest request, PoData poData) {
        //将用户信息加进来
        poData.setUser(noControllerInterface.getLoginUser(request));
    }
}

