package cn.tenfell.tools.nocontroller.config;

import cn.tenfell.tools.nocontroller.filter.LoginHandlerInterceptor;
import cn.tenfell.tools.nocontroller.inface.NoControllerInterface;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
@ComponentScan(basePackages="cn.tenfell.tools.nocontroller"+"*..*")
public class NoControllerConfiguration implements WebMvcConfigurer {
    public static String key;
    @Autowired
    NoControllerInterface noControllerInterface;
    @Override
    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor(new LoginHandlerInterceptor()).excludePathPatterns(noControllerInterface.excludePathPatterns());
    }
    @Override
    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        noControllerInterface.addResourceHandlers(registry);
        registry.addResourceHandler("/**").addResourceLocations("classpath:/static/");
    }
}
