/*
 * Decompiled with CFR 0.152.
 */
package cn.tenfell.tools.nocontroller.utils;

import cn.tenfell.tools.nocontroller.annotation.InterfaceDoc;
import cn.tenfell.tools.nocontroller.annotation.InterfaceModule;
import cn.tenfell.tools.nocontroller.utilsentity.InterfaceDocChild;
import cn.tenfell.tools.nocontroller.utilsentity.InterfaceDocEntity;
import cn.tenfell.tools.nocontroller.utilsentity.InterfaceParams;
import cn.tenfell.tools.nocontroller.utilsentity.PoData;
import cn.tenfell.tools.nocontroller.utilsentity.ServiceCacheData;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ToolsUtils {
    public static List<InterfaceDocEntity> interfaceList = new ArrayList<InterfaceDocEntity>();
    public static String interfaceCreateTime;

    public static boolean isEmpty(CharSequence cs) {
        int strLen;
        if (cs != null && (strLen = cs.length()) != 0) {
            for (int i = 0; i < strLen; ++i) {
                if (Character.isWhitespace(cs.charAt(i))) continue;
                return false;
            }
            return true;
        }
        return true;
    }

    public static boolean equals(String str1, String str2) {
        return str1 == null ? str2 == null : str1.equals(str2);
    }

    public static boolean isArray(Object obj) {
        return obj != null && obj.getClass().isArray();
    }

    public static boolean isCollection(Object obj) {
        return obj != null && obj instanceof Collection;
    }

    public static boolean isMap(Object obj) {
        return obj != null && obj instanceof Map;
    }

    public static boolean isNumber(Object obj) {
        return !(obj != null && obj.getClass() == Byte.TYPE || obj != null && obj.getClass() == Short.TYPE || obj != null && obj.getClass() == Integer.TYPE || obj != null && obj.getClass() == Long.TYPE || obj != null && obj.getClass() == Float.TYPE || obj != null && obj.getClass() == Double.TYPE) ? obj instanceof Number : true;
    }

    public static boolean isString(Object obj) {
        return obj instanceof String || obj instanceof Character;
    }

    public static boolean isBoolean(Object obj) {
        return obj instanceof Boolean || obj != null && obj.getClass() == Boolean.TYPE;
    }

    public static String toJsonString(Object object) {
        StringBuffer sb = new StringBuffer();
        try {
            ToolsUtils.toJsonString(object, sb);
            return sb.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "null";
        }
    }

    private static void toJsonString(Object object, StringBuffer sb) throws IllegalAccessException {
        if (object == null) {
            sb.append("null");
            return;
        }
        if (ToolsUtils.isArray(object)) {
            Object[] arr = (Object[])object;
            sb.append("[");
            for (int i = 0; i < arr.length; ++i) {
                ToolsUtils.toJsonString(arr[i], sb);
                if (i >= arr.length - 1) continue;
                sb.append(",");
            }
            sb.append("]");
        } else if (ToolsUtils.isCollection(object)) {
            Collection coll = (Collection)object;
            int size = coll.size();
            int i = 0;
            Iterator it = coll.iterator();
            sb.append("[");
            while (it.hasNext()) {
                ToolsUtils.toJsonString(it.next(), sb);
                if (++i >= size) continue;
                sb.append(",");
            }
            sb.append("]");
        } else if (ToolsUtils.isMap(object)) {
            Map map = (Map)object;
            Set set = map.keySet();
            int size = set.size();
            int i = 0;
            sb.append("{");
            for (Object key : set) {
                ++i;
                sb.append("\"").append(key.toString()).append("\"").append(":");
                Object val = map.get(key);
                if (val != null && ToolsUtils.isString(val)) {
                    sb.append("\"");
                }
                ToolsUtils.toJsonString(val, sb);
                if (val != null && ToolsUtils.isString(val)) {
                    sb.append("\"");
                }
                if (i >= size) continue;
                sb.append(",");
            }
            sb.append("}");
        } else if (ToolsUtils.isString(object) || ToolsUtils.isBoolean(object) || ToolsUtils.isNumber(object)) {
            sb.append(object.toString());
        } else {
            Field[] fields = object.getClass().getDeclaredFields();
            sb.append("{");
            boolean hasPoint = false;
            for (Field field : fields) {
                int mod = field.getModifiers();
                if (Modifier.isStatic(mod) || Modifier.isFinal(mod)) continue;
                field.setAccessible(true);
                sb.append("\"").append(field.getName()).append("\"").append(":");
                Object value = field.get(object);
                if (value != null && ToolsUtils.isString(value)) {
                    sb.append("\"");
                }
                ToolsUtils.toJsonString(value, sb);
                if (value != null && ToolsUtils.isString(value)) {
                    sb.append("\"");
                }
                sb.append(",");
                hasPoint = true;
            }
            if (hasPoint) {
                sb.delete(sb.length() - 1, sb.length());
            }
            sb.append("}");
        }
    }

    public static void setInterfaceList(List<ServiceCacheData> list) {
        String[] conMappings = new String[]{"json", "jsonp"};
        for (ServiceCacheData serviceCacheData : list) {
            InterfaceDocEntity interfaceDocEntity = null;
            ArrayList<InterfaceDocChild> interfaceDocChildren = null;
            Object service = serviceCacheData.getService();
            List<Method> methodList = serviceCacheData.getMethods();
            for (Method method : methodList) {
                String[] params;
                Class<?>[] types = method.getParameterTypes();
                InterfaceDoc interfaceDoc = method.getAnnotation(InterfaceDoc.class);
                boolean hasDoc = interfaceDoc != null && types.length == 1 && types[0] == PoData.class || types.length == 2 && types[0] == HttpServletRequest.class && types[1] == HttpServletResponse.class;
                if (!hasDoc) continue;
                if (interfaceDocEntity == null) {
                    interfaceDocEntity = new InterfaceDocEntity();
                    interfaceDocChildren = new ArrayList<InterfaceDocChild>();
                    String moduleName = serviceCacheData.getServiceName();
                    InterfaceModule interfaceModule = service.getClass().getAnnotation(InterfaceModule.class);
                    if (interfaceModule != null && !"".equals(interfaceModule.value())) {
                        moduleName = interfaceModule.value();
                    }
                    interfaceDocEntity.setName(moduleName);
                }
                InterfaceDocChild interfaceDocChild = new InterfaceDocChild();
                try {
                    Object returnObj = method.getReturnType().newInstance();
                    interfaceDocChild.setReturnData(ToolsUtils.toJsonString(returnObj));
                }
                catch (Exception returnObj) {
                    // empty catch block
                }
                String interfaceName = method.getName();
                if (interfaceDoc != null && !"".equals(interfaceDoc.name())) {
                    interfaceName = interfaceDoc.name();
                }
                interfaceDocChild.setName(interfaceName);
                ArrayList<InterfaceParams> interfaceParamsList = new ArrayList<InterfaceParams>();
                for (String param : params = interfaceDoc.params()) {
                    String[] paramValues = param.split(interfaceDoc.separator(), 3);
                    InterfaceParams interfaceParams = new InterfaceParams();
                    interfaceParams.setParam(paramValues[0]);
                    interfaceParams.setIsNeed(paramValues[1]);
                    interfaceParams.setParamDesc(paramValues[2]);
                    interfaceParamsList.add(interfaceParams);
                }
                interfaceDocChild.setParams(interfaceParamsList);
                ArrayList<String> urlList = new ArrayList<String>();
                if (types.length == 1 && types[0] == PoData.class) {
                    for (String conMapping : conMappings) {
                        String mapKey = "/" + conMapping + "/" + serviceCacheData.getServiceName() + "/" + method.getName();
                        urlList.add(mapKey);
                    }
                } else if (types.length == 2 && types[0] == HttpServletRequest.class && types[1] == HttpServletResponse.class) {
                    String mapKey = "/selevt/" + serviceCacheData.getServiceName() + "/" + method.getName();
                    urlList.add(mapKey);
                }
                interfaceDocChild.setUrlList(urlList);
                interfaceDocChildren.add(interfaceDocChild);
            }
            if (interfaceDocEntity == null) continue;
            interfaceDocEntity.setList(interfaceDocChildren);
            interfaceList.add(interfaceDocEntity);
        }
        interfaceCreateTime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date());
    }
}

