/*
 * Decompiled with CFR 0.152.
 */
package cn.tenfell.tools.nocontroller.controller;

import cn.tenfell.tools.nocontroller.component.UriHandComponent;
import cn.tenfell.tools.nocontroller.config.NoControllerConfiguration;
import cn.tenfell.tools.nocontroller.inface.NoControllerInterface;
import cn.tenfell.tools.nocontroller.utils.ToolsUtils;
import cn.tenfell.tools.nocontroller.utilsentity.PoData;
import cn.tenfell.tools.nocontroller.utilsentity.UriMap;
import java.io.BufferedReader;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class WebController {
    public static Logger Logger = LoggerFactory.getLogger(WebController.class);
    @Autowired
    ApplicationContext ac;
    @Autowired
    NoControllerInterface noControllerInterface;

    @RequestMapping(value={"/selevt/{1}/{2}"}, produces={"application/json"})
    @ResponseBody
    public void selevt(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Exception throwException = null;
        try {
            UriMap uriMap = UriHandComponent.handMap.get(request.getRequestURI());
            uriMap.getMethod().invoke(uriMap.getService(), request, response);
        }
        catch (Exception e) {
            throwException = e;
        }
        if (throwException != null) {
            Logger.error(WebController.getExceptionAllinformation(throwException, false), (Throwable)throwException);
            throwException.printStackTrace();
            throw throwException;
        }
    }

    @RequestMapping(value={"/json/{1}/{2}"}, produces={"application/json"})
    @ResponseBody
    public Object json(HttpServletRequest request) {
        Object result = this.actionAjax(request, "json");
        return result;
    }

    @RequestMapping(value={"/jsonp/{1}/{2}"}, produces={"application/json"})
    @ResponseBody
    public String jsonp(HttpServletRequest request) {
        Object result = this.actionAjax(request, "jsonp");
        String callback = request.getParameter("callback");
        if (callback == null || "".equals(callback)) {
            callback = "callback";
        }
        return callback + "(" + ToolsUtils.toJsonString(result) + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readRequestBodyAsChars(HttpServletRequest request) {
        BufferedReader br = null;
        StringBuilder sb = new StringBuilder();
        try {
            String str;
            br = request.getReader();
            while ((str = br.readLine()) != null) {
                sb.append(str);
            }
            br.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (null != br) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return sb.toString();
    }

    private static PoData readRequestData(HttpServletRequest request) {
        Map properties = request.getParameterMap();
        PoData poData = new PoData();
        Iterator entries = properties.entrySet().iterator();
        String name = "";
        String value = "";
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            name = (String)entry.getKey();
            Object valueObj = entry.getValue();
            if (null == valueObj) {
                value = "";
            } else if (valueObj instanceof String[]) {
                String[] values = (String[])valueObj;
                for (int i = 0; i < values.length; ++i) {
                    value = values[i] + ",";
                }
                value = value.substring(0, value.length() - 1);
            } else {
                value = valueObj.toString().trim();
            }
            poData.put(name.trim(), value.trim());
        }
        String requestBody = WebController.readRequestBodyAsChars(request);
        if (!ToolsUtils.isEmpty(requestBody)) {
            poData.put("requestBody", requestBody);
        }
        return poData;
    }

    private Object actionAjax(HttpServletRequest request, String type) {
        PoData poData = WebController.readRequestData(request);
        if (ToolsUtils.equals(type, "jsonp")) {
            poData.remove("callback");
        }
        Object result = null;
        try {
            this.addSomeToParam(request, poData);
            UriMap uriMap = UriHandComponent.handMap.get(request.getRequestURI());
            result = uriMap.getMethod().invoke(uriMap.getService(), poData);
        }
        catch (Exception e) {
            result = this.errorReturn(e);
        }
        return result;
    }

    private Object errorReturn(Exception e) {
        String error = WebController.getExceptionAllinformation(e, true);
        String msg = WebController.getExceptionAllinformation(e, false);
        Logger.error(msg, (Throwable)e);
        return this.noControllerInterface.errorReturn(e, msg, error);
    }

    public static String getExceptionAllinformation(Exception e, boolean isAll) {
        if (isAll) {
            StackTraceElement[] stes;
            StringBuffer stringBuffer = new StringBuffer();
            if (e.getMessage() != null) {
                stringBuffer.append(e.getMessage());
                stringBuffer.append(";");
            }
            if (e.getCause() != null) {
                stringBuffer.append(e.getCause().toString() + ";");
            }
            try {
                stes = ((InvocationTargetException)e).getTargetException().getStackTrace();
            }
            catch (Exception e2) {
                stes = e.getStackTrace();
            }
            if (stes != null && stes.length > 0) {
                for (StackTraceElement ste : stes) {
                    stringBuffer.append(ste.toString() + ";");
                }
            }
            return stringBuffer.toString();
        }
        try {
            return ((InvocationTargetException)e).getTargetException().getCause().getMessage();
        }
        catch (Exception e1) {
            return e.getMessage();
        }
    }

    @RequestMapping(value={"/interface/doclist"}, produces={"application/json"})
    @ResponseBody
    public PoData doclist(HttpServletRequest request) {
        PoData poData = new PoData();
        if ("".equals(NoControllerConfiguration.key)) {
            poData.put("flag", true);
            poData.put("list", ToolsUtils.interfaceList);
            poData.put("time", ToolsUtils.interfaceCreateTime);
            return poData;
        }
        if (request.getParameter("key") == null || "".equals(request.getParameter("key"))) {
            poData.put("flag", false);
            poData.put("msg", "\u8bf7\u8f93\u5165\u5bc6\u94a5");
            return poData;
        }
        if (!NoControllerConfiguration.key.equals(request.getParameter("key"))) {
            poData.put("flag", false);
            poData.put("msg", "\u5bc6\u94a5\u9519\u8bef");
            return poData;
        }
        poData.put("flag", true);
        poData.put("list", ToolsUtils.interfaceList);
        poData.put("time", ToolsUtils.interfaceCreateTime);
        return poData;
    }

    public void addSomeToParam(HttpServletRequest request, PoData poData) {
        poData.setUser(this.noControllerInterface.getLoginUser(request));
    }
}

