/*
 * Decompiled with CFR 0.152.
 */
package cn.tenfell.tools.nocontroller.utilsentity;

import cn.tenfell.tools.nocontroller.utils.ToolsUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class PoData
extends HashMap<String, Object>
implements Map<String, Object> {
    private Object user;
    private static final long serialVersionUID = 1L;
    private static Map<String, SimpleDateFormat> sdfMap = new HashMap<String, SimpleDateFormat>();

    public PoData add(String key, Object val) {
        this.put(key, val);
        return this;
    }

    public Double getDouble(String key) {
        return (Double)this.getT(key, Double.class);
    }

    public double getdouble(String key) {
        return (Double)this.getT(key, Double.TYPE);
    }

    public Integer getInteger(String key) {
        return (Integer)this.getT(key, Integer.class);
    }

    public int getInt(String key) {
        return (Integer)this.getT(key, Integer.TYPE);
    }

    public Long getLong(String key) {
        return (Long)this.getT(key, Long.class);
    }

    public long getlong(String key) {
        return (Long)this.getT(key, Long.TYPE);
    }

    public Boolean getBoolean(String key) {
        return (Boolean)this.getT(key, Boolean.class);
    }

    public boolean getboolean(String key) {
        return (Boolean)this.getT(key, Boolean.TYPE);
    }

    public String getString(String key) {
        return (String)this.getT(key, String.class);
    }

    public Date getDate(String key) {
        return (Date)this.getT(key, Date.class);
    }

    private <T> T getT(String key, Class clazz) {
        Object val = this.get(key);
        if (val == null || "".equals(val.toString())) {
            if (clazz == Byte.TYPE) {
                val = (byte)0;
            } else if (clazz == Short.TYPE) {
                val = (short)0;
            } else if (clazz == Integer.TYPE) {
                val = 0;
            } else if (clazz == Long.TYPE) {
                val = 0L;
            } else if (clazz == Float.TYPE) {
                val = Float.valueOf(0.0f);
            } else if (clazz == Double.TYPE) {
                val = 0.0;
            } else if (clazz == Boolean.TYPE) {
                val = false;
            } else if (clazz == Character.TYPE) {
                val = Character.valueOf('\u0000');
            }
            if (val != null) {
                return (T)val;
            }
            return null;
        }
        if (clazz == Byte.class || clazz == Byte.TYPE) {
            Byte num = val instanceof Number ? Byte.valueOf(((Number)val).byteValue()) : Byte.valueOf(Byte.parseByte(val.toString()));
            return (T)num;
        }
        if (clazz == Short.class || clazz == Short.TYPE) {
            Short num = val instanceof Number ? Short.valueOf(((Number)val).shortValue()) : Short.valueOf(Short.parseShort(val.toString()));
            return (T)num;
        }
        if (clazz == Integer.class || clazz == Integer.TYPE) {
            Integer num = val instanceof Number ? Integer.valueOf(((Number)val).intValue()) : Integer.valueOf(Integer.parseInt(val.toString()));
            return (T)num;
        }
        if (clazz == Long.class || clazz == Long.TYPE) {
            Long num = val instanceof Number ? Long.valueOf(((Number)val).longValue()) : Long.valueOf(Long.parseLong(val.toString()));
            return (T)num;
        }
        if (clazz == Float.class || clazz == Float.TYPE) {
            Float num = val instanceof Number ? Float.valueOf(((Number)val).floatValue()) : Float.valueOf(Float.parseFloat(val.toString()));
            return (T)num;
        }
        if (clazz == Double.class || clazz == Double.TYPE) {
            Double num = val instanceof Number ? Double.valueOf(((Number)val).doubleValue()) : Double.valueOf(Double.parseDouble(val.toString()));
            return (T)num;
        }
        if (clazz == Boolean.class || clazz == Boolean.TYPE) {
            Boolean flag = null;
            if (val.equals(Boolean.FALSE) || val instanceof String && val.toString().equalsIgnoreCase("false")) {
                flag = false;
            }
            if (val.equals(Boolean.TRUE) || val instanceof String && val.toString().equalsIgnoreCase("true")) {
                flag = true;
            }
            if (flag != null) {
                return (T)flag;
            }
            throw new RuntimeException(key + "=" + val.toString() + " is not a boolean");
        }
        if (clazz == Character.class || clazz == Character.TYPE) {
            return (T)val;
        }
        if (clazz == Date.class) {
            if (val instanceof Date) {
                return (T)val;
            }
            SimpleDateFormat sdf1 = sdfMap.get("yyyy-MM-dd HH:mm:ss");
            if (sdf1 == null) {
                sdf1 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                sdfMap.put("yyyy-MM-dd HH:mm:ss", sdf1);
            }
            try {
                Date datetime = sdf1.parse(val.toString());
                return (T)datetime;
            }
            catch (Exception e) {
                SimpleDateFormat sdf2 = sdfMap.get("yyyy-MM-dd");
                if (sdf2 == null) {
                    sdf2 = new SimpleDateFormat("yyyy-MM-dd");
                    sdfMap.put("yyyy-MM-dd", sdf2);
                }
                try {
                    Date date = sdf2.parse(val.toString());
                    return (T)date;
                }
                catch (Exception e2) {
                    SimpleDateFormat sdf3 = sdfMap.get("HH:mm:ss");
                    if (sdf3 == null) {
                        sdf3 = new SimpleDateFormat("HH:mm:ss");
                        sdfMap.put("HH:mm:ss", sdf3);
                    }
                    try {
                        Date time = sdf3.parse(val.toString());
                        return (T)time;
                    }
                    catch (Exception e3) {
                        throw new RuntimeException(key + "=" + val.toString() + " is not a timestr");
                    }
                }
            }
        }
        if (clazz == String.class) {
            return (T)val.toString();
        }
        if (clazz == BigDecimal.class) {
            BigDecimal bigDecimal = new BigDecimal(val.toString());
            return (T)bigDecimal;
        }
        return (T)val;
    }

    public <T> T conversion(Class clazz) {
        Object obj;
        PoData poData = this;
        if (poData == null) {
            return null;
        }
        try {
            Field[] fields;
            obj = clazz.newInstance();
            for (Field field : fields = clazz.getDeclaredFields()) {
                int mod = field.getModifiers();
                if (Modifier.isStatic(mod) || Modifier.isFinal(mod)) continue;
                field.setAccessible(true);
                Class<?> type = field.getType();
                T value = poData.getT(field.getName(), type);
                if (value == null) continue;
                field.set(obj, value);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("this object can not cast to" + clazz.getName());
        }
        return obj;
    }

    public <T> T getUser() {
        return (T)this.user;
    }

    public void setUser(Object user) {
        this.user = user;
    }

    public String toJsonString() {
        return ToolsUtils.toJsonString(this);
    }

    public static PoData unConversion(Object object) {
        PoData poData = new PoData();
        try {
            Field[] fields;
            for (Field field : fields = object.getClass().getDeclaredFields()) {
                field.setAccessible(true);
                Object value = field.get(object);
                poData.put(field.getName(), value);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            poData = null;
        }
        return poData;
    }
}

