/*
 * Decompiled with CFR 0.152.
 */
package cn.tenfell.tools.nocontroller.component;

import cn.tenfell.tools.nocontroller.annotation.NeedLogin;
import cn.tenfell.tools.nocontroller.inface.NoControllerInterface;
import cn.tenfell.tools.nocontroller.utils.AopTargetUtils;
import cn.tenfell.tools.nocontroller.utils.ToolsUtils;
import cn.tenfell.tools.nocontroller.utilsentity.PoData;
import cn.tenfell.tools.nocontroller.utilsentity.ServiceCacheData;
import cn.tenfell.tools.nocontroller.utilsentity.UriMap;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Service;

@Component
public class UriHandComponent
implements ApplicationContextAware {
    public static Map<String, UriMap> handMap = new HashMap<String, UriMap>();
    public static NoControllerInterface noControllerInterface;
    @Autowired
    NoControllerInterface noControllerInterfaceService;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        noControllerInterface = this.noControllerInterfaceService;
        String[] conMappings = new String[]{"json", "jsonp"};
        Map serviceMap = applicationContext.getBeansWithAnnotation(Service.class);
        Set keys = serviceMap.keySet();
        ArrayList<ServiceCacheData> serviceCacheDataList = new ArrayList<ServiceCacheData>();
        for (String key : keys) {
            Method[] methods;
            Object service = serviceMap.get(key);
            Object serviceTarget = AopTargetUtils.getTarget(service);
            ServiceCacheData serviceCacheData = new ServiceCacheData();
            serviceCacheData.setService(serviceTarget);
            serviceCacheData.setServiceName(key);
            ArrayList<Method> methodList = new ArrayList<Method>();
            for (Method method : methods = serviceTarget.getClass().getDeclaredMethods()) {
                NeedLogin needLogin;
                UriMap uriMap;
                Class<?>[] types = method.getParameterTypes();
                boolean hasMethod = false;
                if (types.length == 1 && types[0] == PoData.class) {
                    hasMethod = true;
                    uriMap = new UriMap();
                    uriMap.setService(service);
                    uriMap.setMethod(method);
                    needLogin = method.getAnnotation(NeedLogin.class);
                    uriMap.setNeedLogin(needLogin != null);
                    for (String conMapping : conMappings) {
                        String mapKey = "/" + conMapping + "/" + key + "/" + method.getName();
                        handMap.put(mapKey, uriMap);
                    }
                } else if (types.length == 2 && types[0] == HttpServletRequest.class && types[1] == HttpServletResponse.class) {
                    hasMethod = true;
                    uriMap = new UriMap();
                    uriMap.setService(service);
                    uriMap.setMethod(method);
                    needLogin = method.getAnnotation(NeedLogin.class);
                    uriMap.setNeedLogin(needLogin != null);
                    String mapKey = "/selevt/" + key + "/" + method.getName();
                    handMap.put(mapKey, uriMap);
                }
                if (!hasMethod) continue;
                methodList.add(method);
            }
            serviceCacheData.setMethods(methodList);
            serviceCacheDataList.add(serviceCacheData);
        }
        ToolsUtils.setInterfaceList(serviceCacheDataList);
    }
}

