/**
 * Created by fansheng on 2017/9/11.123123
 */
var utils = {
    //消息队列
    //队列实现
    Queue:function Queue() {
        var items = [];
        //队列插入数据
        this.offer = function(obj) {
            items.push(obj);
        };
        //队列取出数据
        this.poll=function(){
            return items.shift();
        };
        //清空队列
        this.empty = function(){
            items = [];
        };
    },
    //ArrayBuffer转Hex
    buff2hex:function(buff){
        return Array.prototype.map.call(new Uint8Array(buff),function(x){return ('00' + x.toString(16)).slice(-2)}).join('').toUpperCase();
    },
    //Hex转ArrayBuffer
    hex2buff:function(hex){
        var typedArray = new Uint8Array(hex.match(/[\da-f]{2}/gi).map(function (h) {
            return parseInt(h, 16)
        }));
        return typedArray.buffer;
    },
    //获取页面指定key值的参数值
    getParamer: function (key) {
        var map = this.getSearch();
        return map[key];
    },
    //获取页面所有key的参数值的集合
    getSearch: function () {
        var search = decodeURIComponent(window.location.search);
        if (search != "") {
            search = search.substring(1);
        } else {
            return {};
        }
        var strsz = search.split("&");
        var map = {};
        for (var i=0; i<strsz.length; i++){
            var strs = strsz[i];
            if (strs.indexOf("=") != -1) {
                var tempsz = strs.split("=");
                var tempkey = tempsz[0];
                var tempvalue = tempsz[1];
                map[tempkey] = tempvalue;
            }
        }
        return map;
    },
    //获取当前网址的host地址 相对深度
    getHost: function () {
        var js="utils.js";
        var scripts = document.getElementsByTagName("script");
        var path = "";
        for (var i = 0, l = scripts.length; i < l; i++) {
            var src = scripts[i].src;
            if (src.indexOf(js) != -1) {
                path = src;
                break;
            }
        }
        var ss = path.split("/");
        ss.length = ss.length - 2;
        path = ss.join("/");
        return path;
    },
    //获取utils对应script的自定义属性
    getAttr: function(name) {
        var js="utils.js";
        var scripts = document.getElementsByTagName("script");
        var val = null;
        for (var i = 0, l = scripts.length; i < l; i++) {
            var src = scripts[i].src;
            if (src.indexOf(js) != -1) {
                path = src;
                val = scripts[i].getAttribute(name);
                break;
            }
        }
        return val;
    },
    //设置cookie
    setCookie: function (name, value) {
        var Days = 30;
        var exp = new Date();
        exp.setTime(exp.getTime() + Days * 24 * 60 * 60 * 1000);
        document.cookie = name + "=" + encodeURIComponent(value) + ";expires=" + exp.toGMTString() + ";path=/";
    },
    //获取指定key值的cookie值
    getCookie: function (name) {
        var arr, reg = new RegExp("(^| )" + name + "=([^;]*)(;|$)");
        if (arr = document.cookie.match(reg)) {
            return decodeURIComponent(arr[2]);
        } else {
            return null;
        }
    },
    //删除指定key值的cookie
    delCookie: function (name) {
        var exp = new Date();
        exp.setTime(exp.getTime() - 1);
        var cval = this.getCookie(name);
        if (cval != null) {
            document.cookie = name + "=" + cval + ";expires=" + exp.toGMTString() + ";path=/";
        }
    },
    //获取指定key值的本地缓存
    getLocalStorage:function(name){
        var mapStr = localStorage.utils;
        if(mapStr==null){
            mapStr = "{}";
        }
        var map = JSON.parse(mapStr);
        return map[name];
    },
    //设置指定key值的本地缓存
    setLocalStorage:function(name,val){
        var mapStr = localStorage.utils;
        if(mapStr==null){
            mapStr = "{}";
        }
        var map = JSON.parse(mapStr);
        map[name] = val;
        localStorage.utils = JSON.stringify(map);
    },
    //删除指定key值的本地缓存
    delLocalStorage:function(name){
        var mapStr = localStorage.utils;
        if(mapStr==null){
            mapStr = "{}";
        }
        var map = JSON.parse(mapStr);
        delete map[name];
        localStorage.utils = JSON.stringify(map);
    },
    messageTips:function(str){
        mini.showTips({
            content: str,
            state: "danger",
            x: "center",
            y: "center",
            timeout: 5000
        });
    },
    //生成UUID
    guid: function () {
        function S4() {
            return (((1 + Math.random()) * 0x10000) | 0).toString(16).substring(1);
        }
        return S4() + S4() + S4() + S4() + S4() + S4() + S4() + S4();
    },
    copyText:function(text){
        var clipboardData = window.clipboardData; //for IE
        if (clipboardData) {
            clipboardData.setData('Text', text);
            utils.messageTips("已经复制")
        }else{
            prompt("当前浏览器不支持复制,请使用Ctrl+C复制",text);
        }
    },
    getUserInfo:function(){
        if(typeof config != "undefined" && config != null){
            return config.getUserInfo();
        }else{
            return null;
        }
    },
    setUserKey:function(key){
        utils.setLocalStorage("authorization",key);
        var url = this.getParamer("url");
        if(url){
            window.location.href = url;
        }
    },
    getUserKey:function(){
        var userKey = utils.getLocalStorage("authorization");
        if(userKey){
            return userKey
        }else{
            return "";
        }
    },
    //加载指定js
    loadJS:function(url){
        var xmlhttp;
        if (window.XMLHttpRequest){
            xmlhttp=new XMLHttpRequest();
        }else{
            xmlhttp=new ActiveXObject("Microsoft.XMLHTTP");
        }
        xmlhttp.onreadystatechange=function(){
            if(xmlhttp.readyState==4 && xmlhttp.status==200){
                eval(xmlhttp.responseText);
            }
        }
        xmlhttp.open("GET",url,false);
        xmlhttp.send();
    },
    divLoading:function(){
        var id = "";
        if(typeof mini != "undefined" && mini != null){
            id = mini.loading("请稍候");
            return id;
        }
        if(typeof Vue != "undefined" && Vue != null){
            if(!utils.loadingVue){
                utils.loadingVue = new Vue();
                utils.loadingVueMap = {};
            }
            if(utils.loadingVue.$loading){
                var vueLoading = utils.loadingVue.$loading({
                    text: '请稍候',
                    lock: true,
                    fullscreen:true,
                    spinner: 'el-icon-loading',
                    background:"#eee"
                });
                id = utils.guid();
                utils.loadingVueMap[id] = vueLoading;
                return id;
            }
        }
        return id;
    },
    divClose:function(id){
        if(typeof mini != "undefined" && mini != null){
            mini.hideMessageBox(id);
            return;
        }
        if(typeof Vue != "undefined" && Vue != null && utils.loadingVueMap){
            if(utils.loadingVue.$loading){
                var vueLoading = utils.loadingVueMap[id];
                if(vueLoading){
                    vueLoading.close();
                    delete utils.loadingVueMap[id];
                }
                return;
            }
        }
    }
};
//取得系统路径
utils.host = utils.getHost();
//加载jquery
utils.loadJS(utils.host+'/plugin/jquery-1.9.0/jquery.min.js');
//ajax全局配置
$.ajaxSetup({
    global: true,
    headers:{
        authorization:utils.getUserKey()
    },
    beforeSend:function(xhr){
        xhr.setRequestHeader("authorization", utils.getUserKey());
        if(this.complete.toString().indexOf("xhr.loading") != -1 && !this.noLoading){
            xhr.loading = utils.divLoading();
        }
    },
    complete:function(xhr,status){
        if(xhr.loading != null && xhr.loading != ""){
            utils.divClose(xhr.loading);
        }
    }
});
//加载配置文件
utils.loadJS(utils.host+'/plugin/config.js');
//加载全局样式
document.write('<style type="text/css">body{margin:0;padding:0;border:0;width:100%;height:100%;overflow:hidden;}</style>');
//加载其他插件
utils.plugs = utils.getAttr("plugin");
if(utils.plugs){
    if(utils.plugs.indexOf("vue") != -1 || utils.plugs.indexOf("element-ui") != -1){
        //加载vue
        document.write('<script src="'+utils.host+'/plugin/vue-2.6.9/vue.js" type="text/javascript" ></sc' + 'ript>');
    }
    if(utils.plugs.indexOf("miniui") != -1){
        //加载miniui
        document.write('<script src="'+utils.host+'/plugin/miniui-3.8.2/miniui.js" type="text/javascript" ></sc' + 'ript>');
        document.write('<link href="'+utils.host+'/plugin/miniui-3.8.2/res/fonts/font-awesome/css/font-awesome.min.css" rel="stylesheet" type="text/css" />');
        document.write('<link href="'+utils.host+'/plugin/miniui-3.8.2/themes/default/miniui.css" rel="stylesheet" type="text/css" />');
        document.write('<link href="'+utils.host+'/plugin/miniui-3.8.2/themes/metro-white/skin.css" rel="stylesheet" type="text/css" />');
        document.write('<link href="'+utils.host+'/plugin/miniui-3.8.2/themes/default/medium-mode.css" rel="stylesheet" type="text/css" />');
        document.write('<link href="'+utils.host+'/plugin/miniui-3.8.2/themes/icons.css" rel="stylesheet" type="text/css" />');
    }
    if(utils.plugs.indexOf("element-ui") != -1){
        //引入element
        document.write('<link rel="stylesheet" href="'+utils.host+'/plugin/element-ui/index.css">');
        document.write('<script src="'+utils.host+'/plugin/element-ui/index.js"></sc' + 'ript>');
        document.write('<style type="text/css">.el-loading-spinner i{color: #000 !important;}.el-loading-spinner .el-loading-text{color: #000 !important;}</style>');
    }
    if(utils.plugs.indexOf("md5") !== -1){
        //加载md5
        document.write('<script src="' + utils.host + '/plugin/md5/jquery.md5.js" type="text/javascript"></sc' + 'ript>');
    }
    if(utils.plugs.indexOf("rtmplayer") !== -1){
        //加载rtmp播放器
        document.write('<script src="' + utils.host + '/plugin/rtmp-player/rtmpplayer.js" type="text/javascript"></sc' + 'ript>');
    }
    if(utils.plugs.indexOf("echarts") !== -1){
        //加载echarts
        document.write('<script src="' + utils.host + '/plugin/echarts-4.2.0/echarts.common.min.js" type="text/javascript"></sc' + 'ript>');
    }
    if(utils.plugs.indexOf("template") !== -1){
        //加载template
        document.write('<script src="' + utils.host + '/plugin/art-template/template.js" type="text/javascript"></sc' + 'ript>');
    }
}
if(typeof config != "undefined" && config != null){
    //加载额外插件
    if(config.plugins != null){
        config.plugins();
    }
    //配置未登录跳转
    if(utils.getAttr("needlogin") == "true") {
        if(!utils.getUserInfo()){
            top.location.href = config.noLoginUrl+"?url="+encodeURIComponent(window.location.href);
        }
    }

}
/*//处理微信登录
wxAutoLogin();
function wxAutoLogin(){
    //1.判断此页面是否需要登录
    if(utils.getAttr("wxlogin") != "true"){
        return;
    }
    //2.判断用户是否已经登录
    var user = utils.getUserInfo();
    if(user){
        return;
    }
    //3.判断是否存在openid
    var wx_jz35_openid = utils.getLocalStorage("wx_jz35_openid");
    if(wx_jz35_openid){
        ajaxLogin(wx_jz35_openid);
        return;
    }
    //4.判断是否存在code
    var code = utils.getParamer("code");
    if(code){
        ajaxGetOpenid(code);
        return;
    }
    //5.code不存在,获取code
    getWxCode();
    function ajaxGetOpenid(code){
        $.ajax({
            url:utils.host+"/json/userService/getOpenId?code="+code,
            dataType:"json",
            async:false,
            success:function(ret){
                if(ret.code == 0){
                    var wx_jz35_openid = ret.obj;
                    utils.setLocalStorage("wx_jz35_openid",wx_jz35_openid);
                    window.location.reload();
                }else{
                    alert(ret.msg);
                }
            }
        });
    }
    function ajaxLogin(wx_jz35_openid){
        var param = {"wx_jz35_openid":wx_jz35_openid};
        utils.userLogin(param,function(code,msg){
            if(code == 1){
                window.location.href = utils.host+"/mobile/wxlogin.html?wx_jz35_openid="+wx_jz35_openid+"&url="+encodeURIComponent(window.location.href);
            }
        });
    }
    function getWxCode(){
        $.ajax({
            url:utils.host+"/json/userService/getWxAppId",
            dataType:"json",
            async:false,
            success:function(ret){
                if(ret.code == 0){
                    var appid = ret.obj;
                    var  redirect_uri= window.location.href;
                    var aut_url ='https://open.weixin.qq.com/connect/oauth2/authorize?appid=APPID&redirect_uri=REDIRECT_URI&response_type=code&scope=snsapi_userinfo&state=1#wechat_redirect';
                    aut_url = aut_url.replace(/APPID/g, appid);
                    aut_url = aut_url.replace(/REDIRECT_URI/g, redirect_uri);
                    window.location.href = aut_url;
                }else{
                    alert(ret.msg);
                }
            }
        });
    }
}*/


