/*
 * Decompiled with CFR 0.152.
 */
package cn.tenfell.tools.transaction.config;

import cn.tenfell.tools.transaction.utilsentity.IsolationLevel;
import cn.tenfell.tools.transaction.utilsentity.PropagationBehavior;
import org.aopalliance.aop.Advice;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.aop.Advisor;
import org.springframework.aop.aspectj.AspectJExpressionPointcutAdvisor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.interceptor.DefaultTransactionAttribute;
import org.springframework.transaction.interceptor.NameMatchTransactionAttributeSource;
import org.springframework.transaction.interceptor.TransactionAttribute;
import org.springframework.transaction.interceptor.TransactionAttributeSource;
import org.springframework.transaction.interceptor.TransactionInterceptor;

@Aspect
@Configuration
@ComponentScan(basePackages={"cn.tenfell.tools.transaction*..*"})
public class GlobalTransactionConfiguration {
    public static String servicePackage;
    public static String[] contains;
    public static PropagationBehavior propagationBehavior;
    public static IsolationLevel isolationLevel;
    @Autowired
    private PlatformTransactionManager transactionManager;

    @Bean
    public TransactionInterceptor txAdvice() {
        DefaultTransactionAttribute dta = new DefaultTransactionAttribute();
        dta.setPropagationBehavior(propagationBehavior.getValue());
        dta.setIsolationLevel(isolationLevel.getValue());
        NameMatchTransactionAttributeSource source = new NameMatchTransactionAttributeSource();
        if (contains == null || contains.length == 0) {
            source.addTransactionalMethod("*", (TransactionAttribute)dta);
        } else {
            for (String contain : contains) {
                source.addTransactionalMethod("*" + contain + "*", (TransactionAttribute)dta);
            }
        }
        TransactionInterceptor transactionInterceptor = new TransactionInterceptor(this.transactionManager, (TransactionAttributeSource)source);
        return transactionInterceptor;
    }

    @Bean
    public Advisor txAdviceAdvisor() {
        AspectJExpressionPointcutAdvisor aspectJExpressionPointcutAdvisor = new AspectJExpressionPointcutAdvisor();
        String AOP_POINTCUT_EXPRESSION = "execution (* " + servicePackage + "..*.*(..))";
        aspectJExpressionPointcutAdvisor.setExpression(AOP_POINTCUT_EXPRESSION);
        aspectJExpressionPointcutAdvisor.setAdvice((Advice)this.txAdvice());
        return aspectJExpressionPointcutAdvisor;
    }
}

