package cn.tenfell.tools.transaction.config;

import cn.tenfell.tools.transaction.annotation.EnableGlobalTransaction;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.AnnotationMetadata;
import cn.tenfell.tools.transaction.utilsentity.IsolationLevel;
import cn.tenfell.tools.transaction.utilsentity.PropagationBehavior;
/**
 * 事务控制注册器
 * @author qq185085781
 * */
public class GlobalTransactionRegistrar implements ImportBeanDefinitionRegistrar {
    @Override
    public void registerBeanDefinitions(AnnotationMetadata annotationMetadata, BeanDefinitionRegistry beanDefinitionRegistry) {
        AnnotationAttributes annotationAttributes = AnnotationAttributes.fromMap(annotationMetadata.getAnnotationAttributes(EnableGlobalTransaction.class.getName()));
        GlobalTransactionConfiguration.servicePackage = annotationAttributes.getString("servicePackage");
        GlobalTransactionConfiguration.contains = annotationAttributes.getStringArray("contains");
        GlobalTransactionConfiguration.propagationBehavior = (PropagationBehavior)annotationAttributes.get("propagationBehavior");
        GlobalTransactionConfiguration.isolationLevel = (IsolationLevel)annotationAttributes.get("isolationLevel");
    }
}
