package cn.tenfell.tools.transaction.config;
import cn.tenfell.tools.transaction.annotation.EnableGlobalTransaction;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.aop.Advisor;
import org.springframework.aop.aspectj.AspectJExpressionPointcutAdvisor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.interceptor.DefaultTransactionAttribute;
import org.springframework.transaction.interceptor.NameMatchTransactionAttributeSource;
import org.springframework.transaction.interceptor.TransactionInterceptor;
import cn.tenfell.tools.transaction.utilsentity.IsolationLevel;
import cn.tenfell.tools.transaction.utilsentity.PropagationBehavior;
/**
 * 事务控制核心业务类
 * @author qq185085781
 * */
@Aspect
@Configuration
@ComponentScan(basePackages="cn.tenfell.tools.transaction"+"*..*")
public class GlobalTransactionConfiguration{
    /**
     * 事务控制所在的service包
     *@see EnableGlobalTransaction#servicePackage()
     *  */
    public static String servicePackage;
    /**
     * 包含事务控制的方法名
     *@see EnableGlobalTransaction#contains()
     *  */
    public static String[] contains;
    /**
     *事务控制传播行为
     * @see EnableGlobalTransaction#propagationBehavior()
     * */
    public static PropagationBehavior propagationBehavior;
    /**
     * 事务控制隔离级别
     *@see EnableGlobalTransaction#isolationLevel()
     *  */
    public static IsolationLevel isolationLevel;
    @Autowired
    private PlatformTransactionManager transactionManager;
    @Bean
    public TransactionInterceptor txAdvice() {
        DefaultTransactionAttribute dta = new DefaultTransactionAttribute();
        //7种事务传播行为 PROPAGATION_REQUIRED,PROPAGATION_SUPPORTS,PROPAGATION_MANDATORY,PROPAGATION_REQUIRES_NEW,PROPAGATION_NOT_SUPPORTED,PROPAGATION_NEVER,PROPAGATION_NESTED
        dta.setPropagationBehavior(propagationBehavior.getValue());
        //5种事务隔离级别 ISOLATION_DEFAULT,ISOLATION_READ_UNCOMMITTED,ISOLATION_READ_COMMITTED,ISOLATION_REPEATABLE_READ,ISOLATION_SERIALIZABLE
        dta.setIsolationLevel(isolationLevel.getValue());
        NameMatchTransactionAttributeSource source = new NameMatchTransactionAttributeSource();
        if(contains == null || contains.length == 0){
            source.addTransactionalMethod("*", dta);
        }else{
            for(String contain:contains){
                source.addTransactionalMethod("*"+contain+"*", dta);
            }
        }
        TransactionInterceptor transactionInterceptor = new TransactionInterceptor(transactionManager, source);
        return transactionInterceptor;
    }
    @Bean
    public Advisor txAdviceAdvisor() {
        AspectJExpressionPointcutAdvisor aspectJExpressionPointcutAdvisor = new AspectJExpressionPointcutAdvisor();
        String AOP_POINTCUT_EXPRESSION = "execution (* "+GlobalTransactionConfiguration.servicePackage+"..*.*(..))";
        aspectJExpressionPointcutAdvisor.setExpression(AOP_POINTCUT_EXPRESSION);
        aspectJExpressionPointcutAdvisor.setAdvice(txAdvice());
        return aspectJExpressionPointcutAdvisor;
    }
}
