package cn.tenfell.tools.transaction.annotation;
import org.springframework.context.annotation.Import;
import cn.tenfell.tools.transaction.config.GlobalTransactionConfiguration;
import cn.tenfell.tools.transaction.config.GlobalTransactionRegistrar;
import cn.tenfell.tools.transaction.utilsentity.IsolationLevel;
import cn.tenfell.tools.transaction.utilsentity.PropagationBehavior;
import java.lang.annotation.*;
/**
 * 启动事物控制的注解
 * @author qq185085781
 * */
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.TYPE})
@Documented
@Import({GlobalTransactionConfiguration.class, GlobalTransactionRegistrar.class})
public @interface EnableGlobalTransaction {
    /**
     * 事务控制的service包名
     * */
    String servicePackage();
    /**
     * 方法名包含的内容
     * */
    String[] contains() default {};
    /**
     * 事务传播行为
     * */
    PropagationBehavior propagationBehavior() default PropagationBehavior.PROPAGATION_REQUIRED;
    /**
     * 事务隔离级别
     * */
    IsolationLevel isolationLevel() default IsolationLevel.ISOLATION_DEFAULT;
}
