package cn.tenfell.tools.transaction.annotation;
import org.springframework.context.annotation.Import;
import cn.tenfell.tools.transaction.config.GlobalTransactionConfiguration;
import cn.tenfell.tools.transaction.config.GlobalTransactionRegistrar;
import cn.tenfell.tools.transaction.utilsentity.IsolationLevel;
import cn.tenfell.tools.transaction.utilsentity.PropagationBehavior;

import java.lang.annotation.*;
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.TYPE})
@Documented
@Import({GlobalTransactionConfiguration.class, GlobalTransactionRegistrar.class})
public @interface EnableGlobalTransaction {
    String servicePackage();
    String[] contains() default {};
    PropagationBehavior propagationBehavior() default PropagationBehavior.PROPAGATION_REQUIRED;
    IsolationLevel isolationLevel() default IsolationLevel.ISOLATION_DEFAULT;
}
