/*
 * Decompiled with CFR 0.152.
 */
package cn.tenfell.tools.autotable.utils;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class PackageUtils {
    public static List<String> getClassName(String packageName) throws IOException {
        return PackageUtils.getClassName(packageName, true);
    }

    public static List<String> getClassName(String packageName, boolean childPackage) throws IOException {
        ArrayList<String> fileNames = new ArrayList<String>();
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        String packagePath = packageName.replace(".", "/");
        Enumeration<URL> urls = loader.getResources(packagePath);
        while (urls.hasMoreElements()) {
            URL url = urls.nextElement();
            if (url == null) continue;
            String type = url.getProtocol();
            if (type.equals("file")) {
                fileNames.addAll(PackageUtils.getClassNameByFile(url.getPath(), childPackage));
                continue;
            }
            if (!type.equals("jar")) continue;
            fileNames.addAll(PackageUtils.getClassNameByJar(url.getPath(), childPackage));
        }
        fileNames.addAll(PackageUtils.getClassNameByJars(((URLClassLoader)loader).getURLs(), packagePath, childPackage));
        ArrayList<String> classNames = new ArrayList<String>();
        for (String fileName : fileNames) {
            int c = (fileName = fileName.replaceAll("\\\\", "/")).indexOf(packagePath);
            if (c == -1) continue;
            String className = fileName.substring(c);
            classNames.add(className.replaceAll("/", "\\."));
        }
        return classNames;
    }

    private static List<String> getClassNameByFile(String filePath, boolean childPackage) throws UnsupportedEncodingException {
        ArrayList<String> myClassName = new ArrayList<String>();
        File file = new File(filePath = URLDecoder.decode(filePath, "utf-8"));
        File[] childFiles = file.listFiles();
        if (childFiles == null) {
            return myClassName;
        }
        for (File childFile : childFiles) {
            if (childFile.isDirectory()) {
                if (!childPackage) continue;
                myClassName.addAll(PackageUtils.getClassNameByFile(childFile.getPath(), childPackage));
                continue;
            }
            String childFilePath = childFile.getPath();
            if (!childFilePath.endsWith(".class")) continue;
            childFilePath = childFilePath.substring(childFilePath.indexOf("/classes/") + 9, childFilePath.lastIndexOf("."));
            childFilePath = childFilePath.replace("/", ".");
            myClassName.add(childFilePath);
        }
        return myClassName;
    }

    private static List<String> getClassNameByJar(String jarPath, boolean childPackage) throws UnsupportedEncodingException {
        ArrayList<String> myClassName = new ArrayList<String>();
        String[] jarInfo = jarPath.split("!");
        String jarFilePath = jarInfo[0].substring(jarInfo[0].indexOf("/"));
        jarFilePath = URLDecoder.decode(jarFilePath, "utf-8");
        String packagePath = jarInfo[1].substring(1);
        try {
            JarFile jarFile = new JarFile(jarFilePath);
            Enumeration<JarEntry> entrys = jarFile.entries();
            while (entrys.hasMoreElements()) {
                JarEntry jarEntry = entrys.nextElement();
                String entryName = jarEntry.getName();
                if (!entryName.endsWith(".class")) continue;
                if (childPackage) {
                    if (!entryName.startsWith(packagePath)) continue;
                    entryName = entryName.replace("/", ".").substring(0, entryName.lastIndexOf("."));
                    myClassName.add(entryName);
                    continue;
                }
                int index = entryName.lastIndexOf("/");
                String myPackagePath = index != -1 ? entryName.substring(0, index) : entryName;
                if (!myPackagePath.equals(packagePath)) continue;
                entryName = entryName.replace("/", ".").substring(0, entryName.lastIndexOf("."));
                myClassName.add(entryName);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return myClassName;
    }

    private static List<String> getClassNameByJars(URL[] urls, String packagePath, boolean childPackage) throws UnsupportedEncodingException {
        ArrayList<String> myClassName = new ArrayList<String>();
        if (urls != null) {
            for (int i = 0; i < urls.length; ++i) {
                URL url = urls[i];
                String urlPath = url.getPath();
                if (urlPath.endsWith("classes/")) continue;
                String jarPath = urlPath + "!/" + packagePath;
                myClassName.addAll(PackageUtils.getClassNameByJar(jarPath, childPackage));
            }
        }
        return myClassName;
    }
}

