/*
 * Decompiled with CFR 0.152.
 */
package cn.tenfell.tools.autotable.component;

import cn.tenfell.tools.autotable.annotation.NoAutoTable;
import cn.tenfell.tools.autotable.config.AutoUpdateTableConfiguration;
import cn.tenfell.tools.autotable.exception.AutoUpdateTableException;
import cn.tenfell.tools.autotable.utils.PackageUtils;
import cn.tenfell.tools.autotable.utils.ToolsUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Component;

@Component
public class AutoUpdateTableService
implements ApplicationContextAware {
    private static String createTableTemplate = "create table %s ( %s )";
    private static String alertTableTemplate = "alter table %s %s";
    private static String dropTableTemplate = "drop table %s";

    /*
     * WARNING - void declaration
     */
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        try {
            boolean auto = AutoUpdateTableConfiguration.auto;
            boolean autoDropTable = AutoUpdateTableConfiguration.autoDropTable;
            boolean autoDropColumn = AutoUpdateTableConfiguration.autoDropColumn;
            if (!auto) {
                return;
            }
            JdbcTemplate jdbcTemplate = (JdbcTemplate)applicationContext.getBean("jdbcTemplate", JdbcTemplate.class);
            String[] entityPackage = AutoUpdateTableConfiguration.entityPackage;
            String dbName = jdbcTemplate.getDataSource().getConnection().getCatalog();
            List columns = jdbcTemplate.queryForList("select table_name,column_name,column_type,column_key from information_schema.columns where table_schema = '" + dbName + "' order by table_name asc,column_name asc");
            HashMap<String, HashMap<String, Object>> tableMap = new HashMap<String, HashMap<String, Object>>();
            for (Object map : columns) {
                HashMap<String, Object> columnMap = (HashMap<String, Object>)tableMap.get(map.get("table_name").toString());
                if (columnMap == null) {
                    columnMap = new HashMap<String, Object>();
                    tableMap.put(map.get("table_name").toString(), columnMap);
                }
                columnMap.put(map.get("column_name").toString(), map);
            }
            ArrayList<String> clazzs = new ArrayList<String>();
            for (String packageName : entityPackage) {
                clazzs.addAll(PackageUtils.getClassName(packageName));
            }
            for (String clazz : clazzs) {
                boolean isFirst;
                StringBuffer columnNames;
                Class<?> classObj = Class.forName(clazz);
                String className = classObj.getName();
                int c = className.lastIndexOf(".");
                if (c != -1) {
                    className = className.substring(c + 1, className.length());
                }
                Object obj = classObj.newInstance();
                Field[] fields = obj.getClass().getDeclaredFields();
                String table_name = ToolsUtils.camelToUnderline(className);
                Map columnMap = (Map)tableMap.get(table_name);
                if (columnMap == null) {
                    void var22_31;
                    columnNames = new StringBuffer();
                    isFirst = true;
                    String string = "";
                    Field[] fieldArray = fields;
                    int n = fieldArray.length;
                    for (int i = 0; i < n; ++i) {
                        Class<?> type;
                        String column_type_byjava;
                        Field field = fieldArray[i];
                        int mod = field.getModifiers();
                        if (Modifier.isStatic(mod) || Modifier.isFinal(mod)) continue;
                        field.setAccessible(true);
                        Annotation[] annotations = field.getDeclaredAnnotations();
                        boolean noAuto = false;
                        for (Annotation annotation : annotations) {
                            if (annotation.annotationType() != NoAutoTable.class) continue;
                            noAuto = true;
                            break;
                        }
                        if (noAuto || "".equals(column_type_byjava = ToolsUtils.javaType2MysqlType(type = field.getType()))) continue;
                        String java_column = ToolsUtils.camelToUnderline(field.getName());
                        columnNames.append(java_column).append(" ").append(column_type_byjava);
                        if (isFirst) {
                            String string2 = java_column;
                            columnNames.append(" not null,");
                            isFirst = false;
                            continue;
                        }
                        columnNames.append(" null default null,");
                    }
                    columnNames.append("primary key (").append((String)var22_31).append(") using btree");
                    String sql = String.format(createTableTemplate, table_name, columnNames.toString());
                    jdbcTemplate.execute(sql);
                } else {
                    columnNames = new StringBuffer();
                    isFirst = true;
                    for (Field field : fields) {
                        Class<?> type;
                        String column_type_byjava;
                        int mod = field.getModifiers();
                        if (Modifier.isStatic(mod) || Modifier.isFinal(mod)) continue;
                        field.setAccessible(true);
                        Annotation[] annotations = field.getDeclaredAnnotations();
                        boolean noAuto = false;
                        for (Annotation annotation : annotations) {
                            if (annotation.annotationType() != NoAutoTable.class) continue;
                            noAuto = true;
                            break;
                        }
                        if (noAuto || "".equals(column_type_byjava = ToolsUtils.javaType2MysqlType(type = field.getType()))) continue;
                        String java_column = ToolsUtils.camelToUnderline(field.getName());
                        Map mysql_column = (Map)columnMap.get(java_column);
                        if (mysql_column == null) {
                            columnNames.append(",add column ").append(java_column).append(" ").append(column_type_byjava);
                            if (isFirst) {
                                columnNames.append(" not null,add primary key (").append(java_column).append(")");
                            } else {
                                columnNames.append(" null");
                            }
                        } else {
                            String column_type = mysql_column.get("column_type").toString();
                            boolean needModify = false;
                            if (type == String.class) {
                                if (column_type.indexOf("char") == -1 && column_type.indexOf("text") == -1) {
                                    needModify = true;
                                }
                            } else if (!column_type.equals(column_type_byjava)) {
                                needModify = true;
                            }
                            if (needModify) {
                                columnNames.append(",modify column ").append(java_column).append(" ").append(column_type_byjava);
                                if (isFirst) {
                                    columnNames.append(" not null");
                                } else {
                                    columnNames.append(" null default null");
                                }
                            }
                            if (isFirst && !"PRI".equals(mysql_column.get("column_key").toString())) {
                                columnNames.append(",add primary key (").append(java_column).append(")");
                            }
                        }
                        if (isFirst) {
                            isFirst = false;
                        }
                        if (!autoDropColumn) continue;
                        columnMap.remove(java_column);
                    }
                    if (autoDropColumn) {
                        Set set = columnMap.keySet();
                        for (String key : set) {
                            columnNames.append(",drop column ").append(key);
                        }
                    }
                    if (columnNames.toString().length() > 1) {
                        String string = columnNames.toString().substring(1);
                        String sql = String.format(alertTableTemplate, table_name, string);
                        jdbcTemplate.execute(sql);
                    }
                }
                if (!autoDropTable) continue;
                tableMap.remove(table_name);
            }
            if (autoDropTable) {
                Set keys = tableMap.keySet();
                StringBuffer tableNames = new StringBuffer();
                for (String key : keys) {
                    tableNames.append(",").append(key);
                }
                if (tableNames.toString().length() > 1) {
                    String drop_table = tableNames.toString().substring(1);
                    String sql = String.format(dropTableTemplate, drop_table);
                    jdbcTemplate.execute(sql);
                }
            }
        }
        catch (Exception e) {
            throw new AutoUpdateTableException(e.getMessage(), e);
        }
    }
}

