package cn.tenfell.tools.admin.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class TimeUtils {
    private static Map<String,SimpleDateFormat> sdfMap = new HashMap<String,SimpleDateFormat>();
    public static String format(Date date, String format){
        SimpleDateFormat sdf = getSimpleDateFormat(format);
        if(date == null){
            date = new Date();
        }
        return sdf.format(date);
    }
    public static Date parse(String timeStr, String format) throws ParseException {
        SimpleDateFormat sdf = getSimpleDateFormat(format);
        return sdf.parse(timeStr);
    }
    private static SimpleDateFormat getSimpleDateFormat(String format){
        SimpleDateFormat sdf = sdfMap.get(format);
        if(sdf == null){
            sdf = new SimpleDateFormat(format);
            sdfMap.put(format,sdf);
        }
        return sdf;
    }
    public static String formatTime(Date date){
        return format(date,"yyyy-MM-dd HH:mm:ss");
    }
    public static String formatTimeNow(){
        return formatTime(new Date());
    }
    public static String formatDay(Date date){
        return format(date,"yyyy-MM-dd");
    }
    public static String formatDayNoRod(Date date){
        return format(date,"yyyyMMdd");
    }
    public static String formatDayNow(){
        return formatDay(new Date());
    }
    public static Date parseTime(String timeStr) throws ParseException{
        return parse(timeStr,"yyyy-MM-dd HH:mm:ss");
    }
    public static Date parseDay(String timeStr) throws ParseException{
        return parse(timeStr,"yyyy-MM-dd");
    }
}
