package cn.tenfell.tools.admin.utils;

import org.apache.commons.codec.binary.Base64;

import javax.crypto.Cipher;
import java.security.*;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;

public class RSAEncrypt {
    private final static String publicKey = "MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQCe2HpNAmU1HAZoDbwBvLetRTMsxMqBKmBUJrusukzepo7ePmSSpo/6OLDJOv6zrBVJkmKYSn7uLtremZtcD/AC6qvEVOU+/LBJIR/ijUfC69nBOnGnCB71yL7h2MOhhtZh5XQsR+3IPpPdchnju9R3IK3HYEuTpCMbl10/VCijGwIDAQAB";
    private final static String privateKey = "MIICdwIBADANBgkqhkiG9w0BAQEFAASCAmEwggJdAgEAAoGBAJ7Yek0CZTUcBmgNvAG8t61FMyzEyoEqYFQmu6y6TN6mjt4+ZJKmj/o4sMk6/rOsFUmSYphKfu4u2t6Zm1wP8ALqq8RU5T78sEkhH+KNR8Lr2cE6cacIHvXIvuHYw6GG1mHldCxH7cg+k91yGeO71HcgrcdgS5OkIxuXXT9UKKMbAgMBAAECgYBhRcXXROE/XbMao1Z/ZdbBF8BX6QbthErLHZEOHGQYcLzKokCqga9nlrHD+Qmic33xuOABzJTgPPcxG7XE8cmStSi392AMfvdcoaI/459WvJCa9LhxVeLCMDxEuuJOtrIFyIpykzZlTOs1SwxA8vKhb+RjMTiGrkL8TL6tjb4HMQJBAO7J5+5t8tfIUrkgZocSMFPjD8BhJRh6hgxPA9AprwTsrCunVov8PO7XB2ztKWIyGM8n/ZLK8loBBPTPe1rN03kCQQCqS3lJOBqEXzq12hUQpL1qQETwiqX2H2F8ZBlCe3WQ6uMLInaKDH9oGfPGkDsPYaWSlL1Y83SM01ay6l7zURIzAkEA2TCKJSKaI8xP+ZRPzQEtNc+r7wYs8HPY4u8nf7m6OBdwjhAZNyAI6BBq75dS8b6xNBKioFa5UkXlFSp2f2QAuQJAGHblQq6LqK6hmZRt6EkyaPw4qzHP687QS3V554Ii/qGv4l6eFvD6sLLhwYng4jHN/oPdu9SlzsFhuCxRXbUs3wJBAOupyIe4xTZZmOeXmzuCBu2rqFSPrUXx7+o1OgxzCId8Mu4VNNzWT4zDvAjP0M/UPS3NUianHf8vCFJHDwFa3hQ=";
    public static void main(String[] args) throws Exception {
        genKeyPair();
    }
    /**
     * 随机生成密钥对
     * @throws NoSuchAlgorithmException
     */
    private static void genKeyPair() throws NoSuchAlgorithmException {
        // KeyPairGenerator类用于生成公钥和私钥对，基于RSA算法生成对象
        KeyPairGenerator keyPairGen = KeyPairGenerator.getInstance("RSA");
        // 初始化密钥对生成器，密钥大小为96-1024位
        keyPairGen.initialize(1024,new SecureRandom());
        // 生成一个密钥对，保存在keyPair中
        KeyPair keyPair = keyPairGen.generateKeyPair();
        RSAPrivateKey privateKey = (RSAPrivateKey) keyPair.getPrivate();   // 得到私钥
        RSAPublicKey publicKey = (RSAPublicKey) keyPair.getPublic();  // 得到公钥
        String publicKeyString = new String(Base64.encodeBase64(publicKey.getEncoded()));
        // 得到私钥字符串
        String privateKeyString = new String(Base64.encodeBase64((privateKey.getEncoded())));
        System.out.println("publicKey:"+publicKeyString);
        System.out.println("privateKey:"+privateKeyString);
    }
    /**
     * RSA公钥加密
     *
     * @param str
     *            加密字符串
     *            公钥
     * @return 密文
     * @throws Exception
     *             加密过程中的异常信息
     */
    public static String encrypt( String str) throws  Exception {
        //base64编码的公钥
        byte[] decoded = Base64.decodeBase64(publicKey);
        RSAPublicKey pubKey = (RSAPublicKey) KeyFactory.getInstance("RSA").generatePublic(new X509EncodedKeySpec(decoded));
        //RSA加密
        Cipher cipher = Cipher.getInstance("RSA");
        cipher.init(Cipher.ENCRYPT_MODE, pubKey);
        String outStr = Base64.encodeBase64String(cipher.doFinal(str.getBytes("UTF-8")));
        return outStr;
    }

    /**
     * RSA私钥解密
     *
     * @param str
     *            加密字符串
     * @return 铭文
     * @throws Exception
     *             解密过程中的异常信息
     */
    public static String decrypt(String str) throws Exception{
        //64位解码加密后的字符串
        byte[] inputByte = Base64.decodeBase64(str.getBytes("UTF-8"));
        //base64编码的私钥
        byte[] decoded = Base64.decodeBase64(privateKey);
        RSAPrivateKey priKey = (RSAPrivateKey) KeyFactory.getInstance("RSA").generatePrivate(new PKCS8EncodedKeySpec(decoded));
        //RSA解密
        Cipher cipher = Cipher.getInstance("RSA");
        cipher.init(Cipher.DECRYPT_MODE, priKey);
        String outStr = new String(cipher.doFinal(inputByte));
        return outStr;
    }

}
