package cn.tenfell.tools.admin.service.system;
import cn.tenfell.tools.admin.entity.system.SystemRoleApp;
import cn.tenfell.tools.admin.mapper.system.SystemRoleAppMapper;
import cn.tenfell.tools.nocontroller.annotation.InterfaceDoc;
import cn.tenfell.tools.nocontroller.annotation.InterfaceModule;
import cn.tenfell.tools.nocontroller.annotation.NeedLogin;
import cn.tenfell.tools.nocontroller.utils.ControllerException;
import cn.tenfell.tools.nocontroller.utils.ToolsUtils;
import cn.tenfell.tools.nocontroller.utilsentity.PoData;
import cn.tenfell.tools.nocontroller.utilsentity.ResponseStatus;
import cn.tenfell.tools.nocontroller.utilsentity.ReturnObj;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import java.util.List;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import java.util.Set;
@Service
@InterfaceModule
public class SystemRoleAppService{
    @Autowired
    SystemRoleAppMapper systemRoleAppMapper;
    //增/改
    @NeedLogin
    @InterfaceDoc
    public ReturnObj save(PoData poData){
        ReturnObj returnObj = new ReturnObj();
        SystemRoleApp param = poData.conversion(SystemRoleApp.class);
        if(param == null){
            throw new ControllerException("请勿篡改参数");
        }
        int n;
        if(param.getVersion() == null){
            param.setVersion(0);
        }
        if(param.getId() == null){
            param.setId(ToolsUtils.getMinUUID());
            n = systemRoleAppMapper.insert(param);
        }else{
            n = systemRoleAppMapper.updateById(param);
        }
        if(n==0){
            throw new ControllerException("保存失败");
        }
        returnObj.setStatus(ResponseStatus.SUCCESS);
        returnObj.setMsg("保存成功");
        return returnObj;
    }
    //分页
    @NeedLogin
    @InterfaceDoc
    public ReturnObj list(PoData poData){
        ReturnObj returnObj = new ReturnObj();
        long current = poData.getLong("current");
        long size = poData.getLong("size");
        if(current == 0){
            current = 1;
        }else{
            int current_add= poData.getInt("current_add");
            current += current_add;
        }
        if(size == 0){
            size = 20;
        }
        PoData search = new PoData();
        Set<String> keys = poData.keySet();
        String sortField=null;
        String sortOrder=null;
        for(String key:keys){
            if("sortField".equals(key)){
                sortField = poData.getString(key);
            }else if("sortOrder".equals(key)){
                sortOrder = poData.getString(key);
            }else if(key.indexOf("Filter") !=-1){
                search.put(key,poData.get(key));
                String tempKey = key.replaceAll("Filter","");
                search.put(tempKey,poData.get(tempKey));
            }
        }
        IPage<SystemRoleApp> page = new Page<SystemRoleApp>();
        page.setCurrent(current);
        page.setSize(size);
        QueryWrapper<SystemRoleApp> wrapper = new QueryWrapper();
        Set<String> searchKeys = search.keySet();
        for(String key:searchKeys){
            if(key.indexOf("Filter") !=-1){
                String field = key.replaceAll("Filter","");
                String filter = search.getString(key);
                String val = search.getString(field);
                String underLineField = ToolsUtils.camelToUnderline(field);
                if("gt".equals(filter)){
                    wrapper.gt(underLineField,val);
                }else if("lt".equals(filter)){
                    wrapper.lt(underLineField,val);
                }else if("eq".equals(filter)){
                    wrapper.eq(underLineField,val);
                }else if("like".equals(filter)){
                    wrapper.like(underLineField,val);
                }else{
                    continue;
                }
            }
        }
        if(!ToolsUtils.isEmpty(sortField) && !ToolsUtils.isEmpty(sortOrder)){
            if("asc".equals(sortOrder)){
                wrapper.orderByAsc(ToolsUtils.camelToUnderline(sortField));
            }else if("desc".equals(sortOrder)){
                wrapper.orderByDesc(ToolsUtils.camelToUnderline(sortField));
            }
        }
        systemRoleAppMapper.selectPage(page,wrapper);
        if(page.getRecords().size() == 0){
            throw new ControllerException("无数据");
        }
        returnObj.setData(page);
        returnObj.setStatus(ResponseStatus.SUCCESS);
        returnObj.setMsg("获取成功");
        return  returnObj;
    }
    //删
    @NeedLogin
    @InterfaceDoc
    public ReturnObj delete(PoData poData){
        ReturnObj returnObj = new ReturnObj();
        SystemRoleApp param = poData.conversion(SystemRoleApp.class);
        if(param == null || param.getId() == null || param.getVersion() == null){
            throw new ControllerException("请勿篡改参数");
        }
        if(systemRoleAppMapper.deleteByMap(poData) == 0){
            throw new ControllerException("删除失败");
        }
        returnObj.setMsg("删除成功");
        returnObj.setStatus(ResponseStatus.SUCCESS);
        return returnObj;
    }
    //删
    @NeedLogin
    @InterfaceDoc
    public ReturnObj deleteAll(PoData poData){
        ReturnObj returnObj = new ReturnObj();
        String dataStr = poData.getString("data");
        if(dataStr == null || "".equals(dataStr.trim())){
            throw new ControllerException("请勿篡改参数");
        }
        List<PoData> list = (List<PoData>)ToolsUtils.toJsonObj(dataStr);
        if(list==null || list.size() == 0){
            throw new ControllerException("请勿篡改参数");
        }
        for(PoData obj:list){
            SystemRoleApp oneData = obj.conversion(SystemRoleApp.class);
            if(oneData == null || oneData.getId() == null || oneData.getVersion() == null){
                throw new ControllerException("请勿篡改参数");
            }
            if(systemRoleAppMapper.deleteByMap(obj) == 0){
                throw new ControllerException("删除失败");
            }
        }
        returnObj.setMsg("删除成功");
        returnObj.setStatus(ResponseStatus.SUCCESS);
        return returnObj;
    }
    //查
    @NeedLogin
    @InterfaceDoc
    public ReturnObj findByMap(PoData poData){
        ReturnObj returnObj = new ReturnObj();
        List<SystemRoleApp> list= systemRoleAppMapper.selectByMap(poData);
        if(list.size() == 0){
            throw new ControllerException("查找失败");
        }
        returnObj.setMsg("查找成功");
        returnObj.setStatus(ResponseStatus.SUCCESS);
        returnObj.setData(list);
        return returnObj;
    }
    //查
    @NeedLogin
    @InterfaceDoc
    public ReturnObj findById(PoData poData){
        ReturnObj returnObj = new ReturnObj();
        SystemRoleApp param = poData.conversion(SystemRoleApp.class);
        SystemRoleApp data= systemRoleAppMapper.selectById(param.getId());
        if(data == null){
            throw new ControllerException("查找失败");
        }
        returnObj.setMsg("查找成功");
        returnObj.setStatus(ResponseStatus.SUCCESS);
        returnObj.setData(data);
        return returnObj;
    }
}
