package cn.tenfell.tools.admin.service;
import cn.tenfell.tools.admin.entity.system.SystemUser;
import cn.tenfell.tools.admin.mapper.system.SystemUserMapper;
import cn.tenfell.tools.admin.uentity.User;
import cn.tenfell.tools.admin.utils.RSAEncrypt;
import cn.tenfell.tools.nocontroller.annotation.InterfaceModule;
import cn.tenfell.tools.nocontroller.inface.NoControllerInterface;
import cn.tenfell.tools.nocontroller.utils.ControllerException;
import cn.tenfell.tools.nocontroller.utils.ToolsUtils;
import cn.tenfell.tools.nocontroller.utilsentity.PoData;
import cn.tenfell.tools.nocontroller.utilsentity.ResponseStatus;
import cn.tenfell.tools.nocontroller.utilsentity.ReturnObj;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import javax.servlet.http.HttpServletRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
@Service
@InterfaceModule("用户登录管理")
public class LoginService implements NoControllerInterface {
    @Autowired
    SystemUserMapper systemUserMapper;
    //对token解密
    private static User decryptAuthorization(String authorization){
        try{
            String json = RSAEncrypt.decrypt(authorization);
            JSONObject jsonObject = JSONObject.fromObject(json);
            Long loginTime = jsonObject.getLong("loginTime");
            if(System.currentTimeMillis() - loginTime>24*60*60*1000){
                //超过token有效期
                return null;
            }
            JSONObject appUserJson = jsonObject.getJSONObject("user");
            User user = (User)JSONObject.toBean(appUserJson,User.class);
            return user;
        }catch (Exception e){
            e.printStackTrace();
            return null;
        }
    }
    //对token加密
    private static String encryptionAuthorization(User user) throws Exception{
        Map<String,Object> map = new HashMap<String,Object>();
        map.put("user",user);
        map.put("loginTime", System.currentTimeMillis());
        String json = JSONObject.fromObject(map).toString();
        String token = RSAEncrypt.encrypt(json);
        return token;
    }
    @Override
    public User getLoginUser(HttpServletRequest request) {
        String authorization = request.getHeader("authorization");
        if(StringUtils.isBlank(authorization)){
            authorization = request.getParameter("authorization");
        }
        if(StringUtils.isBlank(authorization)){
            return null;
        }
        return decryptAuthorization(authorization);
    }

    @Override
    public ReturnObj errorReturn(Exception e, String msg, String error) {
        ReturnObj returnObj = new ReturnObj();
        returnObj.setStatus(ResponseStatus.FAILED);
        returnObj.setMsg(msg);
        returnObj.setError(error);
        return returnObj;
    }

    @Override
    public Object noMethod(HttpServletRequest httpServletRequest) {
        ReturnObj returnObj = new ReturnObj();
        returnObj.setStatus(ResponseStatus.FAILED);
        returnObj.setMsg("此方法已禁止访问");
        return returnObj;
    }

    @Override
    public ReturnObj noLogin(HttpServletRequest httpServletRequest) {
        ReturnObj returnObj = new ReturnObj();
        returnObj.setStatus(ResponseStatus.NOLOGIN);
        returnObj.setMsg("用户未登录");
        return returnObj;
    }
    public ReturnObj getTokenUser(PoData poData){
        HttpServletRequest request = ((ServletRequestAttributes) RequestContextHolder.getRequestAttributes()).getRequest();
        User user = this.getLoginUser(request);
        ReturnObj returnObj = new ReturnObj();
        returnObj.setStatus(user != null?ResponseStatus.SUCCESS:ResponseStatus.NOLOGIN);
        returnObj.setData(user);
        return returnObj;
    }
    public ReturnObj ajaxLogin(PoData poData) throws Exception{
        ReturnObj returnObj = new ReturnObj();
        String username = poData.getString("username");
        String password = poData.getString("password");
        if(StringUtils.isBlank(username) || StringUtils.isBlank(password)){
            throw new ControllerException("用户名或密码不可为空");
        }
        Map<String,Object> map = new HashMap<String,Object>();
        map.put("username",username);
        map.put("password",password);
        List<SystemUser> list = systemUserMapper.selectByMap(map);
        if(list.size() != 1){
            throw new ControllerException("用户名或密码不正确");
        }
        SystemUser systemUser = list.get(0);
        setToken(returnObj,systemUser);
        return returnObj;
    }
    private static void setToken(ReturnObj returnObj,SystemUser systemUser) throws Exception{
        User user = new User();
        user.setId(systemUser.getId());
        user.setUsername(systemUser.getUsername());
        user.setName(systemUser.getName());
        returnObj.setStatus(ResponseStatus.SUCCESS);
        String token = encryptionAuthorization(user);
        returnObj.setData(token);
    }
    public ReturnObj ajaxReg(PoData poData) throws Exception{
        ReturnObj returnObj = new ReturnObj();
        String username = poData.getString("username");
        String password = poData.getString("password");
        String name = poData.getString("name");
        if(StringUtils.isBlank(username) || StringUtils.isBlank(password) || StringUtils.isBlank(name)){
            throw new ControllerException("用户名,密码,姓名不可为空");
        }
        Map<String,Object> map = new HashMap<String,Object>();
        map.put("username",username);
        List<SystemUser> list = systemUserMapper.selectByMap(map);
        if(list.size()>0){
            throw new ControllerException("当前用户已存在");
        }
        SystemUser systemUser =  poData.conversion(SystemUser.class);
        systemUser.setId(ToolsUtils.getMinUUID());
        if(systemUserMapper.insert(systemUser) == 0){
            throw new ControllerException("注册失败,请重试");
        }
        setToken(returnObj,systemUser);
        return returnObj;
    }
}
