package cn.tenfell.tools.admin;
import cn.tenfell.tools.autotable.annotation.EnableAutoUpdateTable;
import cn.tenfell.tools.generator.annotation.EnableAutoGenerator;
import cn.tenfell.tools.nocontroller.annotation.EnableNoController;
import cn.tenfell.tools.transaction.annotation.EnableGlobalTransaction;
import com.baomidou.mybatisplus.extension.plugins.OptimisticLockerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.PaginationInterceptor;
import com.baomidou.mybatisplus.extension.plugins.PerformanceInterceptor;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Profile;
@SpringBootApplication
@EnableAutoUpdateTable(entityPackage="cn.tenfell.tools.admin.entity")
@EnableAutoGenerator(entityPackage = "cn.tenfell.tools.admin.entity")
@EnableNoController()
@EnableGlobalTransaction(servicePackage = "cn.tenfell.tools.admin.service",contains = {"save","insert","update","delete"})
@MapperScan("cn.tenfell.tools.admin.mapper")
public class WebAdminApplication {
    public static void main(String[] args) {
        SpringApplication.run(WebAdminApplication.class, args);
    }
    @Bean
    public PaginationInterceptor paginationInterceptor() {
        return new PaginationInterceptor();
    }
    @Bean
    public OptimisticLockerInterceptor optimisticLockerInterceptor() {
        return new OptimisticLockerInterceptor();
    }
    @Bean
    @Profile({"dev","test"})// 设置 dev test 环境开启
    public PerformanceInterceptor performanceInterceptor() {
        return new PerformanceInterceptor();
    }
}
