package cn.tenfell.plugins.mybatisplus.utils;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.extension.toolkit.SqlHelper;
import org.apache.ibatis.javassist.ClassClassPath;
import org.apache.ibatis.javassist.ClassPool;
import org.apache.ibatis.javassist.CtClass;
import org.apache.ibatis.javassist.bytecode.ClassFile;
import org.apache.ibatis.javassist.bytecode.SignatureAttribute;
import org.mybatis.spring.SqlSessionTemplate;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class MapperLoaderUtils {
    public static SqlSessionTemplate sqlSessionTemplate;
    private static final HashMap<Class,Class> classMap = new HashMap<>();
    private static final List<Action> needInitList = new Vector<>();
    private static Class getMapperClass(Class entity){
        if(classMap.get(entity) != null){
            return classMap.get(entity);
        }
        try{
            TableInfo tableInfo = SqlHelper.table(entity);
            return Class.forName(tableInfo.getCurrentNamespace());
        }catch (Exception e){

        }
        String packageName = entity.getPackage().getName();
        String simpleMapperName = entity.getSimpleName()+"Mapper";
        String className = packageName+"."+simpleMapperName;
        Class<?> mapperClass = signClass(entity.getName(),className);
        classMap.put(entity,mapperClass);
        return classMap.get(entity);
    }
    private static Class signClass(String beanClassName,String mapperClassName){
        Class superClass = BaseMapper.class;
        try{
            return Class.forName(mapperClassName);
        }catch (Exception e){

        }
        try {
            ClassPool classPool = ClassPool.getDefault();
            classPool.insertClassPath(new ClassClassPath(superClass));
            CtClass superMapper = classPool.getCtClass(superClass.getName());
            CtClass mapper = classPool.makeInterface(mapperClassName, superMapper);
            ClassFile classFile = mapper.getClassFile();
            String superInterfaceClazzSignature = "L"+superClass.getName().replace(".class", "").replace('.', '/');
            String signatureReturnType = "L"+"java/lang/Object;";
            String paramterClassSignature = "L"+beanClassName.replace(".class", "").replace('.', '/') +";";
            String signature = signatureReturnType+ superInterfaceClazzSignature+"<" + paramterClassSignature + ">;";
            SignatureAttribute signatureAttribute = new SignatureAttribute(
                    classFile.getConstPool(),
                    signature);
            classFile.addAttribute(signatureAttribute);
            Class mapperClass = mapper.toClass();
            //手工解除绑定，释放内存
            mapper.detach();
            return mapperClass;
        } catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println(mapperClassName+"未编译成功");
        return null;
    }
    private static void addMapper(Class entity){
        sqlSessionTemplate.getConfiguration().addMapper(getMapperClass(entity));
    }
    public static <T extends BaseMapper<E>,E> T getMapper(Class<E> entity){
        Object obj;
        try{
            obj = sqlSessionTemplate.getMapper(getMapperClass(entity));
        }catch (Exception e){
            addMapper(entity);
            obj = sqlSessionTemplate.getMapper(getMapperClass(entity));
        }
        return (T)obj;
    }
    public static void asyncAction(Action action){
        if(MapperLoaderUtils.sqlSessionTemplate == null){
            MapperLoaderUtils.needInitList.add(action);
        }else{
            action.tdo();
        }
    }
    public static void init(SqlSessionTemplate sqlSession){
        MapperLoaderUtils.sqlSessionTemplate = sqlSession;
        if(MapperLoaderUtils.sqlSessionTemplate == null){
            return;
        }
        if(MapperLoaderUtils.needInitList.size()>0){
            Iterator<Action> it=MapperLoaderUtils.needInitList.iterator();
            while(it.hasNext()){
                it.next().tdo();
                it.remove();
            }
        }
    }
    public interface Action{
        void tdo();
    }
}
