package cn.tenfell.plugins.mybatisplus.interce;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.toolkit.PluginUtils;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.plugin.*;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;

import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

/**
 * @author fs
 */
@Intercepts({@Signature(type = StatementHandler.class, method = "prepare", args = {Connection.class, Integer.class})})
public class TableFieldSelectInterceptor implements Interceptor {
    private final static ThreadLocal<List<String>> SQL_LIST = new ThreadLocal<>();
    public static void add(String column){
        List<String> list = getSqlList();
        if(list == null){
            list = new ArrayList<>();
            SQL_LIST.set(list);
        }
        list.add(column);
    }
    private static List<String> getSqlList(){
        return SQL_LIST.get();
    }
    private static Object handler(Invocation invocation) throws InvocationTargetException,IllegalAccessException {
        if(getSqlList() != null){
            SQL_LIST.remove();
        }
        return invocation.proceed();
    }
    @Override
    public Object intercept(Invocation invocation) throws Exception{
        List<String> list = getSqlList();
        if(list == null || list.size() == 0){
            return handler(invocation);
        }
        StatementHandler statementHandler = PluginUtils.realTarget(invocation.getTarget());
        MetaObject metaObject = SystemMetaObject.forObject(statementHandler);
        // 先判断是不是SELECT操作
        MappedStatement mappedStatement = (MappedStatement) metaObject.getValue("delegate.mappedStatement");
        if (!SqlCommandType.SELECT.equals(mappedStatement.getSqlCommandType())) {
            return handler(invocation);
        }
        BoundSql boundSql = (BoundSql) metaObject.getValue("delegate.boundSql");
        // 原始sql
        String originalSql = boundSql.getSql();
        String originalSqlAfter = getTableFieldSelectSql(originalSql);
        if(!StrUtil.equals(originalSql,originalSqlAfter)){
            // 设置新的sql
            metaObject.setValue("delegate.boundSql.sql", originalSqlAfter);
        }
        return handler(invocation);
    }

    private String getTableFieldSelectSql(String oldSql){
        if(!StrUtil.startWith(oldSql,"SELECT")){
            return oldSql;
        }
        try{
            String sql = " "+CollUtil.join(getSqlList(),",")+",";
            String newSql = oldSql.substring(0,6)+sql+oldSql.substring(6);
            return newSql;
        }catch (Exception e){
            return oldSql;
        }
    }
    /**
     * 生成拦截对象的代理
     *
     * @param target 目标对象
     * @return 代理对象
     */
    @Override
    public Object plugin(Object target) {
        if (target instanceof StatementHandler) {
            return Plugin.wrap(target, this);
        }
        return target;
    }

    /**
     * mybatis配置的属性
     *
     * @param properties mybatis配置的属性
     */
    @Override
    public void setProperties(Properties properties) {

    }
}
