package cn.tenfell.plugins.mybatisplus.entity;

import cn.tenfell.plugins.mybatisplus.utils.MapperUtils;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import lombok.Data;
import lombok.NonNull;

import java.util.ArrayList;
import java.util.List;
public class FieldSelect<P,C>{
    private FieldSelectData<P,C> data;
    public FieldSelect(){
        this.data = new FieldSelectData<>();
        this.data.setParentKeys(new ArrayList<SFunction<P,?>>());
        this.data.setChildKeys(new ArrayList<SFunction<C,?>>());
    }
    public FieldSelect<P,C> init(@NonNull Class<P> parentCls){
        this.data.setParentCls(parentCls);
        return this;
    }
    public FieldSelect<P,C> select(@NonNull SFunction<C,?> childFld){
        this.select(MapperUtils.getUnderlineName(childFld));
        return this;
    }
    public FieldSelect<P,C> select(@NonNull String column){
        this.data.setChildColumn(column);
        return this;
    }
    public FieldSelect<P,C> from(@NonNull Class<C> childCls){
        this.data.setChildCls(childCls);
        return this;
    }
    public FieldSelect<P,C> whereOrAnd(@NonNull SFunction<C,?> childKey,@NonNull SFunction<P,?> parentKey){
        this.data.getChildKeys().add(childKey);
        this.data.getParentKeys().add(parentKey);
        return this;
    }
    public FieldSelect<P,C> last(String lastSql){
        this.data.setChildLastSql(lastSql);
        return this;
    }
    public FieldSelect<P,C> as(@NonNull SFunction<P,?> parentFld){
        this.data.setParentFld(parentFld);
        return this;
    }
    public FieldSelectData getData(){
        return this.data;
    }
    @Data
    public static class FieldSelectData<P,C>{
        private Class<P> parentCls;
        private Class<C> childCls;
        private SFunction<P,?> parentFld;
        private String childColumn;
        private String childLastSql;
        private List<SFunction<P,?>> parentKeys;
        private List<SFunction<C,?>> childKeys;
    }
}
