package cn.tenfell.plugins.mybatisplus.entity;
import cn.hutool.core.collection.CollUtil;
import cn.tenfell.plugins.mybatisplus.utils.MapperUtils;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import lombok.Data;
import lombok.NonNull;
import java.util.ArrayList;
import java.util.List;

public class ChildrenSelect<P,C> {
    private ChildrenSelectData<P,C> data;
    public ChildrenSelect(){
        this.data = new ChildrenSelect.ChildrenSelectData<>();
        this.data.setParentKeys(new ArrayList<SFunction<P,?>>());
        this.data.setChildKeys(new ArrayList<SFunction<C,?>>());
    }
    public ChildrenSelect<P,C> init(@NonNull Class<P> parentCls){
        this.data.setParentCls(parentCls);
        return this;
    }
    public ChildrenSelect<P,C> selectAll(){
        this.data.setChildCols(null);
        return this;
    }
    public ChildrenSelect<P,C> select(SFunction<C,?>... columns){
        String[] strs = new String[columns.length];
        for(int i=0;i<columns.length;i++){
            strs[i] = MapperUtils.getUnderlineName(columns[i]);
        }
        return select(strs);
    }
    public ChildrenSelect<P,C> select(String... columns){
        List<String> list = CollUtil.toList(columns);
        this.data.setChildCols(list);
        return this;
    }
    public ChildrenSelect<P,C> from(Class<C> childCls){
        this.data.setChildCls(childCls);
        return this;
    }
    public ChildrenSelect<P,C> whereOrAnd(SFunction<C,?> childKey,SFunction<P,?> parentKey){
        this.data.getChildKeys().add(childKey);
        this.data.getParentKeys().add(parentKey);
        return this;
    }
    public ChildrenSelect<P,C> last(String lastSql){
        this.data.setChildLastSql(lastSql);
        return this;
    }
    public ChildrenSelect.ChildrenSelectData getData(){
        return this.data;
    }
    @Data
    public static class ChildrenSelectData<P,C>{
        private Class<P> parentCls;
        private Class<C> childCls;
        private List<String> childCols;
        private String childLastSql;
        private List<SFunction<P,?>> parentKeys;
        private List<SFunction<C,?>> childKeys;
    }
}
