package cn.tenfell.common.redis.serializer;

import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.XmlUtil;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.SerializationException;
import org.xml.sax.InputSource;

import java.beans.XMLEncoder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;

/**
 * hutool工具类的序列化
 * @author fs
 */
public class HutoolXmlSerializer implements RedisSerializer<Object> {
    @Override
    public byte[] serialize(Object o) throws SerializationException {
        if(o==null){
            return new byte[0];
        }else{
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            XMLEncoder xmlEncoder = new XMLEncoder(baos);
            xmlEncoder.writeObject(o);
            IoUtil.close(xmlEncoder);
            return baos.toByteArray();
        }
    }

    @Override
    public Object deserialize(byte[] bytes) throws SerializationException {
        if(bytes == null || bytes.length == 0){
            return null;
        }else{
            return XmlUtil.readObjectFromXml(new InputSource(new ByteArrayInputStream(bytes)));
        }
    }
}
