package cn.tenfell.common.redis.queue;

import cn.tenfell.common.redis.emu.ReceiveStatus;

/**
 * 消息队列接收器
 * 实现此抽象类的Spring实例即可通过receive方法实时接收队列数据
 * @author fs
 * @param <T>
 */
public interface RedisMessageQueue<T>{
    /**
     * 消息订阅
     * @param data  消息体
     * @return
     */
    ReceiveStatus receive(T data);

    /**
     * 线程线程数
     * @return
     */
    int count();

    /**
     * 获取队列实体
     * @return
     */
    RedisQueue<T> getRedisQueue();
}
