/*
 * Decompiled with CFR 0.152.
 */
package cn.tenfell.common.redis;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.StrUtil;
import cn.tenfell.common.core.SpringIocHolder;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.jsontype.PolymorphicTypeValidator;
import com.fasterxml.jackson.databind.jsontype.impl.LaissezFaireSubTypeValidator;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.GenericJackson2JsonRedisSerializer;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.SerializationException;
import org.springframework.data.redis.serializer.StringRedisSerializer;

public final class RedisUtils {
    private static final Logger log = LoggerFactory.getLogger(RedisUtils.class);
    private static RedisTemplate redisTemplate;
    private static List<Consumer<RedisTemplate>> needInitList;

    private static RedisSerializer<Object> redisSerializer() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        objectMapper.configure(DeserializationFeature.FAIL_ON_INVALID_SUBTYPE, false);
        objectMapper.configure(SerializationFeature.WRITE_DATE_KEYS_AS_TIMESTAMPS, false);
        objectMapper.registerModule((Module)new JavaTimeModule());
        objectMapper.activateDefaultTyping((PolymorphicTypeValidator)LaissezFaireSubTypeValidator.instance, ObjectMapper.DefaultTyping.EVERYTHING, JsonTypeInfo.As.PROPERTY);
        GenericJackson2JsonRedisSerializer.registerNullValueSerializer((ObjectMapper)objectMapper, null);
        return new GenericJackson2JsonRedisSerializer(objectMapper);
    }

    public static void init(RedisTemplate redisTemplate) {
        RedisSerializer<Object> redisSerializer = RedisUtils.redisSerializer();
        redisTemplate.setKeySerializer((RedisSerializer)StringRedisSerializer.UTF_8);
        redisTemplate.setHashKeySerializer((RedisSerializer)StringRedisSerializer.UTF_8);
        redisTemplate.setValueSerializer(redisSerializer);
        redisTemplate.setHashValueSerializer(redisSerializer);
        RedisUtils.redisTemplate = redisTemplate;
        if (needInitList.size() > 0) {
            Iterator<Consumer<RedisTemplate>> it = needInitList.iterator();
            while (it.hasNext()) {
                RedisUtils.action(it.next());
                it.remove();
            }
        }
    }

    public static <T> T get(String key) {
        try {
            Object value = redisTemplate.opsForValue().get((Object)key);
            return (T)value;
        }
        catch (SerializationException e) {
            log.error("\u53cd\u5e8f\u5217\u5316\u5931\u8d25:{}", (Object)e.getMessage());
            return null;
        }
    }

    public static <T> T get(String key, T def) {
        T t = RedisUtils.get(key);
        if (t == null) {
            t = def;
        }
        return t;
    }

    public static <T> void set(String key, T val) {
        RedisUtils.set(key, val, null);
    }

    public static <T> void set(String key, T val, Long minutes) {
        if (minutes == null) {
            redisTemplate.opsForValue().set((Object)key, val);
        } else {
            redisTemplate.opsForValue().set((Object)key, val, minutes.longValue(), TimeUnit.MINUTES);
        }
    }

    public static void del(String key) {
        if (StrUtil.isBlank((CharSequence)key)) {
            return;
        }
        redisTemplate.delete((Object)key);
    }

    public static boolean has(String key) {
        if (StrUtil.isBlank((CharSequence)key)) {
            return false;
        }
        return redisTemplate.hasKey((Object)key);
    }

    public static void getRedisTemplate(Consumer<RedisTemplate> consumer) {
        if (redisTemplate == null) {
            needInitList.add(consumer);
        } else {
            RedisUtils.action(consumer);
        }
    }

    private static void action(Consumer<RedisTemplate> consumer) {
        try {
            consumer.accept(redisTemplate);
        }
        catch (Exception e) {
            log.error("getRedisTemplate\u6267\u884c\u5931\u8d25:{}", (Throwable)e);
        }
    }

    private RedisUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        needInitList = new Vector<Consumer<RedisTemplate>>();
        SpringIocHolder.asyncAction((Consumer)new Consumer<ApplicationContext>(){

            @Override
            public void accept(ApplicationContext applicationContext) {
                String[] names;
                RedisTemplate tempRedisTemplate = null;
                for (String name : names = applicationContext.getBeanNamesForType(RedisTemplate.class)) {
                    Object temp = applicationContext.getBean(name, RedisTemplate.class);
                    if (temp.getClass() != RedisTemplate.class) continue;
                    tempRedisTemplate = (RedisTemplate)temp;
                    break;
                }
                Assert.notNull(tempRedisTemplate, (String)"redisTemplate\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                RedisUtils.init(tempRedisTemplate);
            }
        });
    }
}

