/*
 * Decompiled with CFR 0.152.
 */
package cn.tenfell.common.redis;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.lang.Dict;
import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.StrUtil;
import cn.tenfell.common.core.SpringIocHolder;
import cn.tenfell.common.core.ThreadKeepActiveUtil;
import cn.tenfell.common.redis.RedisUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.springframework.context.ApplicationContext;
import org.springframework.data.redis.core.ListOperations;
import org.springframework.data.redis.core.RedisTemplate;

public class RedisQueue<E> {
    private static RedisTemplate redisTemplate;
    private static Map<String, List<String>> threadMap;
    String key;
    ListOperations<String, E> operation;

    public static void init() {
        if (redisTemplate != null) {
            return;
        }
        RedisUtils.getRedisTemplate(new Consumer<RedisTemplate>(){

            @Override
            public void accept(RedisTemplate redisTemplate) {
                redisTemplate = redisTemplate;
                RedisQueue.receiveInit();
            }
        });
    }

    private static void receiveInit() {
        SpringIocHolder.asyncAction((Consumer)new Consumer<ApplicationContext>(){

            @Override
            public void accept(ApplicationContext applicationContext) {
                String[] names;
                for (String name : names = applicationContext.getBeanNamesForType(RedisMessageQueue.class)) {
                    RedisMessageQueue rmq = (RedisMessageQueue)applicationContext.getBean(name, RedisMessageQueue.class);
                    RedisQueue rq = rmq.getRedisQueue();
                    RedisQueueReceive rqr = new RedisQueueReceive(rmq, rq);
                    ArrayList<String> threads = (ArrayList<String>)threadMap.get(name);
                    if (threads == null) {
                        threads = new ArrayList<String>();
                        int counts = rmq.count();
                        if (counts < 1) {
                            counts = 1;
                        }
                        for (int i = 0; i < counts; ++i) {
                            threads.add(IdUtil.simpleUUID());
                        }
                        threadMap.put(name, threads);
                    }
                    for (String id : threads) {
                        ThreadKeepActiveUtil.keepActive((String)id, (Runnable)rqr);
                    }
                    RedisQueueOffer copyBakToMaster = new RedisQueueOffer(rq);
                    ThreadKeepActiveUtil.keepActive((String)IdUtil.simpleUUID(), (Runnable)copyBakToMaster);
                }
            }
        });
    }

    public RedisQueue(String topic, String tag) {
        RedisQueue that = this;
        if (StrUtil.isBlank((CharSequence)topic)) {
            topic = "queue";
        }
        that.key = topic + ":" + tag;
        that.operation = redisTemplate.opsForList();
    }

    public RedisQueue(String tag) {
        this(null, tag);
    }

    public boolean offer(E data) {
        if (StrUtil.isBlank((CharSequence)this.key) || data == null) {
            return false;
        }
        Long length = this.operation.leftPush((Object)(this.key + ":master"), data);
        return length > 0L;
    }

    public void empty() {
        if (StrUtil.isBlank((CharSequence)this.key)) {
            return;
        }
        redisTemplate.delete((Object)this.key);
    }

    public E poll() {
        if (StrUtil.isBlank((CharSequence)this.key)) {
            return null;
        }
        Object data = this.operation.rightPop((Object)(this.key + ":master"));
        return (E)data;
    }

    public E poll(Long seconds) {
        if (StrUtil.isBlank((CharSequence)this.key)) {
            return null;
        }
        if (seconds == null || seconds < 5L) {
            seconds = 30L;
        }
        Object data = this.operation.rightPop((Object)(this.key + ":master"), seconds.longValue(), TimeUnit.SECONDS);
        return (E)data;
    }

    public Dict pollAndBak() {
        if (StrUtil.isBlank((CharSequence)this.key)) {
            return null;
        }
        String id = System.currentTimeMillis() + ":" + IdUtil.getSnowflake((long)1L, (long)1L).nextIdStr();
        Object data = this.operation.rightPopAndLeftPush((Object)(this.key + ":master"), (Object)(this.key + ":bak:" + id));
        return Dict.create().set("data", data).set("id", (Object)id);
    }

    public Dict pollAndBak(Long seconds) {
        if (StrUtil.isBlank((CharSequence)this.key)) {
            return null;
        }
        if (seconds == null || seconds < 5L) {
            seconds = 30L;
        }
        String id = System.currentTimeMillis() + ":" + IdUtil.getSnowflake((long)1L, (long)1L).nextIdStr();
        Object data = this.operation.rightPopAndLeftPush((Object)(this.key + ":master"), (Object)(this.key + ":bak:" + id), seconds.longValue(), TimeUnit.SECONDS);
        return Dict.create().set("data", data).set("id", (Object)id);
    }

    public void delBak(String id) {
        this.operation.rightPop((Object)(this.key + ":bak:" + id));
    }

    public void ackPoll(Consumer<E> consumer) {
        Dict dict = this.pollAndBak();
        if (dict == null) {
            return;
        }
        Object data = dict.getBean("data");
        String id = dict.getStr("id");
        if (data == null) {
            return;
        }
        try {
            consumer.accept(data);
            this.delBak(id);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public long size() {
        if (StrUtil.isBlank((CharSequence)this.key)) {
            return 0L;
        }
        Long length = this.operation.size((Object)(this.key + ":master"));
        if (length == null) {
            length = 0L;
        }
        return length;
    }

    static {
        threadMap = new HashMap<String, List<String>>();
        RedisQueue.init();
    }

    public static abstract class RedisMessageQueue<T> {
        public abstract void receive(T var1);

        public abstract boolean confirm();

        public abstract int count();

        public abstract RedisQueue<T> getRedisQueue();

        public boolean send(T data) {
            RedisQueue<T> redisQueue = this.getRedisQueue();
            return redisQueue.offer(data);
        }
    }

    private static class RedisQueueOffer
    implements Runnable {
        RedisQueue redisQueue;

        public RedisQueueOffer(RedisQueue redisQueue) {
            this.redisQueue = redisQueue;
        }

        @Override
        public void run() {
            Set keys = redisTemplate.keys((Object)(this.redisQueue.key + ":bak:*"));
            for (String key : keys) {
                String[] sz = key.split(":");
                Long time = Convert.toLong((Object)sz[sz.length - 2]);
                if (System.currentTimeMillis() - time < 0L) continue;
                this.redisQueue.operation.rightPopAndLeftPush((Object)key, (Object)(this.redisQueue.key + ":master"));
            }
        }
    }

    private static class RedisQueueReceive
    implements Runnable {
        RedisMessageQueue redisMessageQueue;
        RedisQueue redisQueue;

        public RedisQueueReceive(RedisMessageQueue redisMessageQueue, RedisQueue redisQueue) {
            this.redisMessageQueue = redisMessageQueue;
            this.redisQueue = redisQueue;
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        String id;
                        Object data;
                        if (this.redisMessageQueue.confirm()) {
                            Dict dict = this.redisQueue.pollAndBak(30L);
                            data = dict.getBean("data");
                            id = dict.getStr("id");
                        } else {
                            data = this.redisQueue.poll(30L);
                            id = null;
                        }
                        this.redisMessageQueue.receive(data);
                        if (!this.redisMessageQueue.confirm()) continue;
                        this.redisQueue.delBak(id);
                    }
                }
                catch (Exception exception) {
                    continue;
                }
                break;
            }
        }
    }
}

