/*
 * Decompiled with CFR 0.152.
 */
package cn.tenfell.common.redis;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.StrUtil;
import cn.tenfell.common.core.SpringIocHolder;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.jsontype.PolymorphicTypeValidator;
import com.fasterxml.jackson.databind.jsontype.impl.LaissezFaireSubTypeValidator;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.GenericJackson2JsonRedisSerializer;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.SerializationException;
import org.springframework.data.redis.serializer.StringRedisSerializer;

public final class RedisUtils {
    private static final Logger log = LoggerFactory.getLogger(RedisUtils.class);
    private static String keyPrefix = "";
    private static RedisTemplate redisTemplate;

    public static RedisSerializer<Object> redisSerializer() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        objectMapper.configure(DeserializationFeature.FAIL_ON_INVALID_SUBTYPE, false);
        objectMapper.configure(SerializationFeature.WRITE_DATE_KEYS_AS_TIMESTAMPS, false);
        objectMapper.registerModule((Module)new JavaTimeModule());
        objectMapper.activateDefaultTyping((PolymorphicTypeValidator)LaissezFaireSubTypeValidator.instance, ObjectMapper.DefaultTyping.NON_FINAL, JsonTypeInfo.As.PROPERTY);
        GenericJackson2JsonRedisSerializer.registerNullValueSerializer((ObjectMapper)objectMapper, null);
        return new GenericJackson2JsonRedisSerializer(objectMapper);
    }

    public static void setKeyPrefix(String prefix) {
        keyPrefix = prefix;
    }

    public static <T> T get(String key) {
        try {
            Object value = redisTemplate.opsForValue().get((Object)(keyPrefix + key));
            Map map = (Map)value;
            return (T)map.get("data");
        }
        catch (SerializationException e) {
            log.error("\u53cd\u5e8f\u5217\u5316\u5931\u8d25:{}", (Object)e.getMessage());
            return null;
        }
    }

    public static <T> T get(String key, T def) {
        T t = RedisUtils.get(key);
        if (t == null) {
            t = def;
        }
        return t;
    }

    public static <T> void set(String key, T val) {
        RedisUtils.set(key, val, null);
    }

    public static <T> void set(String key, T val, Long minutes) {
        HashMap<String, T> map = new HashMap<String, T>(1);
        map.put("data", val);
        if (minutes == null) {
            redisTemplate.opsForValue().set((Object)(keyPrefix + key), map);
        } else {
            redisTemplate.opsForValue().set((Object)(keyPrefix + key), map, minutes.longValue(), TimeUnit.MINUTES);
        }
    }

    public static void del(String key) {
        if (StrUtil.isBlank((CharSequence)key)) {
            return;
        }
        redisTemplate.delete((Object)(keyPrefix + key));
    }

    public static boolean has(String key) {
        if (StrUtil.isBlank((CharSequence)key)) {
            return false;
        }
        return redisTemplate.hasKey((Object)(keyPrefix + key));
    }

    private RedisUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        SpringIocHolder.asyncAction((Consumer)new Consumer<ApplicationContext>(){

            @Override
            public void accept(ApplicationContext applicationContext) {
                String[] names;
                for (String name : names = applicationContext.getBeanNamesForType(RedisTemplate.class)) {
                    Object temp = applicationContext.getBean(name, RedisTemplate.class);
                    if (temp.getClass() != RedisTemplate.class) continue;
                    redisTemplate = (RedisTemplate)temp;
                    break;
                }
                Assert.notNull((Object)redisTemplate, (String)"redisTemplate\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                RedisSerializer<Object> redisSerializer = RedisUtils.redisSerializer();
                redisTemplate.setKeySerializer((RedisSerializer)StringRedisSerializer.UTF_8);
                redisTemplate.setHashKeySerializer((RedisSerializer)StringRedisSerializer.UTF_8);
                redisTemplate.setValueSerializer(redisSerializer);
                redisTemplate.setHashValueSerializer(redisSerializer);
            }
        });
    }
}

