/*
 * Decompiled with CFR 0.152.
 */
package cn.tenfell.common.core;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.cron.CronUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ThreadKeepActiveUtil {
    private static List<ThreadMap> threadMaps = new ArrayList<ThreadMap>();
    private static int time = 10;

    private static void init() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                ThreadKeepActiveUtil.checkAndRestart(null, null);
            }
        };
        String cron = "*/" + time + " * * * * *";
        CronUtil.schedule((String)cron, (Runnable)runnable);
        CronUtil.setMatchSecond((boolean)true);
        CronUtil.start((boolean)true);
    }

    public static void keepActive(Runnable runnable) {
        ThreadKeepActiveUtil.keepActive(IdUtil.simpleUUID(), runnable);
    }

    public static void keepActive(String id, Runnable runnable) {
        Assert.isTrue((StrUtil.isNotBlank((CharSequence)id) && runnable != null ? 1 : 0) != 0, (String)"id\u6216\u8005\u7ebf\u7a0b\u4e0d\u53ef\u4e3a\u7a7a", (Object[])new Object[0]);
        ThreadKeepActiveUtil.checkAndRestart(id, runnable);
    }

    private static synchronized void checkAndRestart(String id, Runnable runnable) {
        Iterator<ThreadMap> it = threadMaps.iterator();
        ArrayList<ThreadMap> addList = null;
        while (it.hasNext()) {
            ThreadMap temp = it.next();
            if (temp.getThread().isAlive()) continue;
            if (addList == null) {
                addList = new ArrayList();
            }
            if (StrUtil.equals((CharSequence)temp.getId(), (CharSequence)id)) {
                temp.setRunnable(runnable);
                id = null;
                runnable = null;
            }
            addList.add(temp);
            it.remove();
        }
        if (StrUtil.isNotBlank((CharSequence)id) && runnable != null) {
            if (addList == null) {
                addList = new ArrayList<ThreadMap>();
            }
            ThreadMap threadMap = new ThreadMap();
            threadMap.setId(id);
            threadMap.setRunnable(runnable);
            addList.add(threadMap);
        }
        if (addList != null) {
            for (ThreadMap temp : addList) {
                Thread thread = new Thread(temp.getRunnable());
                temp.setThread(thread);
                threadMaps.add(temp);
                thread.start();
            }
        }
    }

    static {
        ThreadKeepActiveUtil.init();
    }

    private static class ThreadMap {
        private String id;
        private Runnable runnable;
        private Thread thread;

        public String getId() {
            return this.id;
        }

        public Runnable getRunnable() {
            return this.runnable;
        }

        public Thread getThread() {
            return this.thread;
        }

        public void setId(String id) {
            this.id = id;
        }

        public void setRunnable(Runnable runnable) {
            this.runnable = runnable;
        }

        public void setThread(Thread thread) {
            this.thread = thread;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ThreadMap)) {
                return false;
            }
            ThreadMap other = (ThreadMap)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            Runnable this$runnable = this.getRunnable();
            Runnable other$runnable = other.getRunnable();
            if (this$runnable == null ? other$runnable != null : !this$runnable.equals(other$runnable)) {
                return false;
            }
            Thread this$thread = this.getThread();
            Thread other$thread = other.getThread();
            return !(this$thread == null ? other$thread != null : !this$thread.equals(other$thread));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ThreadMap;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            Runnable $runnable = this.getRunnable();
            result = result * 59 + ($runnable == null ? 43 : $runnable.hashCode());
            Thread $thread = this.getThread();
            result = result * 59 + ($thread == null ? 43 : $thread.hashCode());
            return result;
        }

        public String toString() {
            return "ThreadKeepActiveUtil.ThreadMap(id=" + this.getId() + ", runnable=" + this.getRunnable() + ", thread=" + this.getThread() + ")";
        }
    }
}

