/*
 * Decompiled with CFR 0.152.
 */
package cn.tenfell.common.core;

import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Configuration;

@Configuration
public class SpringIocHolder
implements ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(SpringIocHolder.class);
    private static ApplicationContext applicationContext;
    private static List<Consumer<ApplicationContext>> needInitList;

    public static <T> T getBean(Class<T> clazz) {
        return SpringIocHolder.getBean(null, clazz);
    }

    public static <T> T getBean(String name) {
        return SpringIocHolder.getBean(name, null);
    }

    public static <T> T getBean(String name, Class<T> clazz) {
        if (applicationContext == null) {
            return null;
        }
        if (name != null && clazz != null) {
            return (T)applicationContext.getBean(name, clazz);
        }
        if (name != null) {
            return (T)applicationContext.getBean(name);
        }
        if (clazz != null) {
            return (T)applicationContext.getBean(clazz);
        }
        return null;
    }

    public static <T> void asyncGetBean(Class<T> clazz, Consumer<T> consumer) {
        SpringIocHolder.asyncGetBean(null, clazz, consumer);
    }

    public static <T> void asyncGetBean(String name, Consumer<T> consumer) {
        SpringIocHolder.asyncGetBean(name, null, consumer);
    }

    public static <T> void asyncGetBean(final String name, final Class<T> clazz, final Consumer<T> consumer) {
        SpringIocHolder.asyncAction(new Consumer<ApplicationContext>(){

            @Override
            public void accept(ApplicationContext applicationContext) {
                Object t = SpringIocHolder.getBean(name, clazz);
                consumer.accept(t);
            }
        });
    }

    public static void asyncAction(Consumer<ApplicationContext> consumer) {
        if (applicationContext == null) {
            needInitList.add(consumer);
        } else {
            SpringIocHolder.action(consumer);
        }
    }

    private static void action(Consumer<ApplicationContext> consumer) {
        try {
            consumer.accept(applicationContext);
        }
        catch (Exception e) {
            log.error("SpringIoc\u6267\u884c\u5931\u8d25:{}", (Throwable)e);
        }
    }

    private static void init() {
        if (needInitList.size() > 0) {
            Iterator<Consumer<ApplicationContext>> it = needInitList.iterator();
            while (it.hasNext()) {
                SpringIocHolder.action(it.next());
                it.remove();
            }
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        SpringIocHolder.applicationContext = applicationContext;
        SpringIocHolder.init();
    }

    static {
        needInitList = new Vector<Consumer<ApplicationContext>>();
    }
}

