/*
 * Decompiled with CFR 0.152.
 */
package cn.tdchain.cb.util;

import cn.tdchain.cb.util.StringUtils;
import cn.tdchain.cipher.Cipher;
import cn.tdchain.cipher.CipherException;
import cn.tdchain.cipher.Key;
import cn.tdchain.tdmsp.Msp;
import cn.tdchain.tdmsp.util.PkiUtil;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.io.File;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.util.List;

public class TdcbConfig {
    public static final int AIO = 1;
    public static final int NIO = 2;
    public static final int IO = 3;
    private static volatile TdcbConfig instance;
    private static final String SYSTEM_CONFIG_FILE = "tdcb.conf";
    private String alias = "tdbc-key";
    private String connectionToken;
    private String[] ipTables;
    private int port;
    private int cePort;
    private String rootKspath;
    private String localKsPath;
    private String localKsPassword;
    private String accountKsPath;
    private Cipher cipher = new Cipher();
    private Key key = new Key();

    private void init() {
        String userJarDir = System.getProperty("user.dir");
        String filePath = userJarDir + "/" + SYSTEM_CONFIG_FILE;
        File file = new File(filePath);
        Config config = file.exists() ? ConfigFactory.parseFile((File)file) : ConfigFactory.load((String)SYSTEM_CONFIG_FILE);
        this.connectionToken = config.getString("tdcb.connection.token");
        List iplist = config.getStringList("tdcb.connection.iptables");
        this.ipTables = new String[iplist.size()];
        iplist.toArray(this.ipTables);
        this.port = config.getInt("tdcb.connection.port");
        this.cePort = config.getInt("tdcb.connection.ce.port");
        if (config.hasPath("tdcb.cert.root")) {
            this.rootKspath = config.getString("tdcb.cert.root");
        }
        this.localKsPath = config.getString("tdcb.cert.local.keystore");
        this.localKsPassword = config.getString("tdcb.cert.local.password");
        if (StringUtils.isBlank(this.localKsPath) || StringUtils.isBlank(this.localKsPassword)) {
            throw new RuntimeException("Illegal keystore configuration.");
        }
        this.accountKsPath = config.getString("tdcb.contract.account.kspath");
        this.dealKey();
    }

    private void dealKey() {
        try {
            KeyStore keyStore = Msp.getKeyStore((String)this.localKsPath, (String)this.localKsPassword);
            if (keyStore == null) {
                throw new CipherException("Local node KeyStore is null!");
            }
            String privateKey = this.cipher.getPrivateKeyStringByKeyStore(keyStore, this.localKsPassword, Msp.ORGANIZATION_ALIAS);
            String publicKey = this.cipher.getPublicKeyStringByStore(keyStore, this.localKsPassword, Msp.ORGANIZATION_ALIAS);
            if (StringUtils.isBlank(privateKey) || StringUtils.isBlank(publicKey)) {
                throw new RuntimeException("Failed to load key pair: " + this.localKsPath + ".");
            }
            X509Certificate endCert = (X509Certificate)keyStore.getCertificate(Msp.ORGANIZATION_ALIAS);
            String localCertBase64String = Msp.certToBase64String((X509Certificate)endCert);
            this.key.setPrivateKey(privateKey);
            this.key.setPublicKey(publicKey);
            this.key.setLocalCertBase64String(localCertBase64String);
            if (!StringUtils.isBlank(this.rootKspath)) {
                X509Certificate rootCert = PkiUtil.getCertFromCer((String)this.rootKspath);
                String rootCertBase64String = Msp.certToBase64String((X509Certificate)rootCert);
                if (StringUtils.isBlank(rootCertBase64String)) {
                    throw new RuntimeException("Failed to load root cert: " + this.rootKspath + ".");
                }
                this.key.setRootCertBase64String(rootCertBase64String);
            }
        }
        catch (Exception e) {
            throw new CipherException("get private key by key store error:" + e.getMessage());
        }
    }

    public static synchronized TdcbConfig getInstance() {
        if (instance == null) {
            instance = new TdcbConfig();
            instance.init();
        }
        return instance;
    }

    public String getAccountKsPath() {
        return this.accountKsPath;
    }

    public String getLocalKsPath() {
        return this.localKsPath;
    }

    public String getLocalKsPassword() {
        return this.localKsPassword;
    }

    public String getConnectionToken() {
        return this.connectionToken;
    }

    public String[] getIpTables() {
        return this.ipTables;
    }

    public int getPort() {
        return this.port;
    }

    public int getCePort() {
        return this.cePort;
    }

    public Cipher getCipher() {
        return this.cipher;
    }

    public Key getKey() {
        return this.key;
    }

    public String getAlias() {
        return this.alias;
    }
}

