/*
 * Decompiled with CFR 0.152.
 */
package cn.tdchain.cb.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;

public final class JsonUtils {
    private JsonUtils() {
    }

    public static String toJson(Object src) {
        return JSON.toJSONString((Object)src);
    }

    public static String toJson(Object src, SerializerFeature ... features) {
        return JSON.toJSONString((Object)src, (SerializerFeature[])features);
    }

    public static <T> T fromJson(String json, Type typeOfT) {
        try {
            return (T)JSON.parseObject((String)json, (Type)typeOfT, (Feature[])new Feature[0]);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static List<String> fromListString(String json) {
        try {
            return (List)JSON.parseObject((String)json, (Type)TypeReference.LIST_STRING, (Feature[])new Feature[0]);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Map<String, String> fromMapString(String json) {
        try {
            return (Map)JSON.parseObject((String)json, (Type)new TypeReference<Map<String, String>>(){}.getType(), (Feature[])new Feature[0]);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Object bytes2Object(byte[] bytes, Class<?> classType) {
        return JSON.parseObject((byte[])bytes, classType, (Feature[])new Feature[0]);
    }

    public static byte[] object2Bytes(Object object) {
        return JSON.toJSONBytes((Object)object, (SerializerFeature[])new SerializerFeature[0]);
    }
}

