package cn.tdchain.cb.util;

import cn.tdchain.jbcc.Connection;
import cn.tdchain.jbcc.ConnectionFactory;
import cn.tdchain.jbcc.ConnectionFactory.ConnectionConfig.Builder;

/**
 * Connection Utility.
 *
 *
 * @version 1.0
 * @author bingoer.H 2018-12-05
 */
public class ConnectionUtils {

    private static Connection con;

    private static String token = TdcbConfig.getInstance().getConnectionToken();

    private static String[] ipTables = TdcbConfig.getInstance().getIpTables();

    private static int port = TdcbConfig.getInstance().getPort();

    private ConnectionUtils() {
    }

    /**
     * Get connection.
     * 
     * @return Connection
     */
    public static Connection getConnection() {
        if (con == null) {
            Builder builder = ConnectionFactory.ConnectionConfig.builder()
                    .iptables(ipTables).port(port).token(token)
                    .keystorePath(TdcbConfig.getInstance().getLocalKsPath())
                    .keystorePassword(
                            TdcbConfig.getInstance().getLocalKsPassword());
            if (TdcbConfig.getInstance().isShowPrint()) {
                builder = builder.showPrint();
            }
            ConnectionFactory factory = builder.build();
            con = factory.getConnection();
        }
        return con;
    }

}
