package cn.tdchain.cb.util;

import java.util.Collection;
import java.util.Map;

/**
 * Collection Utilities.
 *
 * @version 1.0
 * @author Administrator 2019-01-31
 */
public class CollectionUtils {

    private CollectionUtils() {
    }

    /**
     * Return {@code true} if the supplied Collection is {@code null} or empty. <br>
     * Otherwise, return {@code false}.
     * 
     * @param collection the Collection to check
     * @return whether the given Collection is empty
     */
    public static boolean isEmpty(Collection<?> collection) {
        return (collection == null || collection.isEmpty());
    }

    /**
     * Return {@code false} if the supplied Collection is {@code null} or empty. <br>
     * Otherwise, return {@code true}.
     * 
     * @param collection the Collection to check
     * @return whether the given Collection is empty
     */
    public static boolean isNotEmpty(Collection<?> collection) {
        return !isEmpty(collection);
    }

    /**
     * Return {@code true} if the supplied Map is {@code null} or empty. <br>
     * Otherwise, return {@code false}.
     * 
     * @param map the Map to check
     * @return whether the given Map is empty
     */
    public static boolean isEmpty(Map<?, ?> map) {
        return (map == null || map.isEmpty());
    }

    /**
     * Return {@code false} if the supplied Map is {@code null} or empty. <br>
     * Otherwise, return {@code true}.
     * 
     * @param map the Map to check
     * @return whether the given Map is empty
     */
    public static boolean isNotEmpty(Map<?, ?> map) {
        return !isEmpty(map);
    }
}
