package cn.tdchain.cb.util;

import java.nio.charset.StandardCharsets;
import java.util.Base64;

/**
 * Base 64 Utility.
 *
 * @version 1.0
 * @author Yaochuang 2019-01-04
 */
public final class Base64Util {

    private Base64Util() {
    }

    /**
     * 编码.
     *
     * @param source String
     * @return String
     */
    public static String encoder(String source) {
        if (source == null) {
            return null;
        }
        byte[] encode = Base64.getEncoder()
                .encode(source.getBytes(StandardCharsets.UTF_8));
        return new String(encode, StandardCharsets.UTF_8);
    }

    /**
     * 编码.
     *
     * @param source byte[]
     * @return String
     */
    public static String encoder(byte[] source) {
        if (source == null) {
            return null;
        }
        byte[] encode = Base64.getEncoder().encode(source);
        return new String(encode, StandardCharsets.UTF_8);
    }

    /**
     * 解码.
     *
     * @param source String
     * @return String
     */
    public static String decoder(String source) {
        if (source == null) {
            return null;
        }
        byte[] decode = Base64.getDecoder()
                .decode(source.getBytes(StandardCharsets.UTF_8));
        return new String(decode, StandardCharsets.UTF_8);
    }

    /**
     * 解码.
     *
     * @param source String
     * @return byte[]
     */
    public static byte[] byteDecoder(String source) {
        if (source == null) {
            return null;
        }
        return Base64.getDecoder()
                .decode(source.getBytes(StandardCharsets.UTF_8));
    }

    /**
     * 解码.
     *
     * @param source byte[]
     * @return String
     */
    public static String decoder(byte[] source) {
        if (source == null) {
            return null;
        }
        byte[] decode = Base64.getDecoder().decode(source);
        return new String(decode, StandardCharsets.UTF_8);
    }

}
