package cn.tdchain.cb.domain;

import org.apache.commons.lang3.StringUtils;

import com.alibaba.fastjson.annotation.JSONField;

import cn.tdchain.cb.constant.KeyAndType;

/**
 * Contract.
 * 
 * @version 1.0
 * @author bingoer.H 2018-12-03
 */
public class Contract extends BaseEntity {

    private static final long serialVersionUID = 8431913333271293796L;

    private String name;

    private String description;

    private String templateName;

    private String address;

    private String args;

    private String referenceHash;

    private int version;

    private boolean frozen;

    private Long createTime;

    private Long timestamp;

    /**
     * Default constructor.
     */
    public Contract() {
    }

    /**
     * Constructor.
     * 
     * @param name contract name
     * @param description contract description
     * @param templateName template name
     * @param address owner address
     * @param args contract arguments
     * @param createTime create time
     * @param referenceHash reference contract state transaction hash
     */
    public Contract(String name, String description, String templateName,
            String address, String args, String referenceHash,
            Long createTime) {
        this.name = name;
        this.description = description;
        this.templateName = templateName;
        this.address = address;
        this.args = args;
        this.referenceHash = referenceHash;
        this.frozen = false;
        this.version = 1;
        this.createTime = createTime;
        this.timestamp = createTime;
    }

    /**
     * Update contract data.
     * 
     * @param timestamp String
     * @param version int
     * @param referenceHash contract state hash
     * @param frozen boolean
     * @param templateName String
     */
    public void update(Long timestamp, int version, String referenceHash,
                       boolean frozen, String templateName) {
        this.timestamp = timestamp;
        this.version = version;
        this.referenceHash = referenceHash;
        this.frozen = frozen;
        if (!StringUtils.isBlank(templateName)) {
            this.templateName = templateName;
        }
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getTemplateName() {
        return templateName;
    }

    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getArgs() {
        return args;
    }

    public void setArgs(String args) {
        this.args = args;
    }

    public String getReferenceHash() {
        return referenceHash;
    }

    public void setReferenceHash(String referenceHash) {
        this.referenceHash = referenceHash;
    }

    public int getVersion() {
        return version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public boolean isFrozen() {
        return frozen;
    }

    public void setFrozen(boolean frozen) {
        this.frozen = frozen;
    }

    public Long getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Long createTime) {
        this.createTime = createTime;
    }

    public Long getTimestamp() {
        return timestamp;
    }

    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    @JSONField(serialize = false, deserialize = false)
    @Override
    public String getKey() {
        return KeyAndType.getContractKey(this.name);
    }

    @JSONField(serialize = false, deserialize = false)
    @Override
    public String getType() {
        return KeyAndType.C;
    }

}
