package cn.tdchain.cb.domain;

import com.alibaba.fastjson.annotation.JSONField;

import cn.tdchain.cb.constant.KeyAndType;

/**
 * Account.
 * 
 * @version 1.0
 * @author bingoer.H 2018-11-29
 */
public class AccountContract extends BaseEntity {

    private static final long serialVersionUID = 449732885821610451L;

    private String address;

    private String contractName;

    /**
     * Default constructor.
     */
    public AccountContract() {
    }

    /**
     * Constructor.
     * 
     * @param address account address
     * @param contractName contract name
     */
    public AccountContract(String address, String contractName) {
        this.address = address;
        this.contractName = contractName;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }

    @JSONField(serialize = false, deserialize = false)
    @Override
    public String getKey() {
        return KeyAndType.getAccountContractKey(this.address,
                this.contractName);
    }

    @JSONField(serialize = false, deserialize = false)
    @Override
    public String getType() {
        return KeyAndType.getAccountContractType(this.address);
    }

}
