package cn.tdchain.cb.domain;

import com.alibaba.fastjson.annotation.JSONField;

import cn.tdchain.cb.constant.KeyAndType;
import cn.tdchain.cipher.Cipher;

/**
 * Account.
 * 
 * @version 1.0
 * @author bingoer.H 2018-11-29
 */
public class Account extends BaseEntity {

    private static final long serialVersionUID = -4073088839754447596L;

    private String address;

    private boolean frozen;

    private Auth auth;

    private String crypto;

    private String keyStore;

    private String info;

    private Long createTime;

    private Long timestamp;

    /**
     * Default constructor.
     */
    public Account() {
    }

    /**
     * Constructor.
     * 
     * @param address account address
     * @param crypto "RSA" or "SM
     * @param keyStore key store
     * @param info account info
     * @param createTime create time
     */
    public Account(String address, String crypto, String keyStore, String info,
                   Long createTime) {
        this.address = address;
        this.frozen = false;
        this.keyStore = keyStore;
        this.info = info;
        this.createTime = createTime;
        this.timestamp = createTime;
        if (Cipher.Type.SM.name().equals(crypto)) {
            this.crypto = crypto;
        } else {
            this.crypto = Cipher.Type.RSA.name();
        }
        auth = Auth.NORMAL;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public boolean isFrozen() {
        return frozen;
    }

    public void setFrozen(boolean frozen) {
        this.frozen = frozen;
    }

    public Auth getAuth() {
        return auth;
    }

    public void setAuth(Auth auth) {
        this.auth = auth;
    }

    public String getCrypto() {
        return crypto;
    }

    public void setCrypto(String crypto) {
        this.crypto = crypto;
    }

    public String getKeyStore() {
        return keyStore;
    }

    public void setKeyStore(String keyStore) {
        this.keyStore = keyStore;
    }

    public String getInfo() {
        return info;
    }

    public void setInfo(String info) {
        this.info = info;
    }

    public Long getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Long createTime) {
        this.createTime = createTime;
    }

    public Long getTimestamp() {
        return timestamp;
    }

    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    @JSONField(serialize = false, deserialize = false)
    @Override
    public String getKey() {
        return KeyAndType.getAccountKey(this.address);
    }

    @JSONField(serialize = false, deserialize = false)
    @Override
    public String getType() {
        return KeyAndType.A;
    }

}
