/*
 * Decompiled with CFR 0.152.
 */
package cn.tdchain.tdmsp.ca.config;

import cn.tdchain.cipher.utils.CipherUtil;
import cn.tdchain.tdmsp.Msp;
import java.io.File;
import java.security.cert.X509Certificate;

public class SystemConfig {
    private String RSA_ISSUERDN = "rsarootca@tdbc@CN";
    private String SM_ISSUERDN = "smrootca@tdbc@CN";
    private String issuerdn;
    private String rootAlias;
    private String rootPassword;
    private String rootKsPath;
    private String rootKsFileName;
    private int validTime;
    private String organizationUnit;
    private String country;
    private String commonName;
    private X509Certificate[] chain;
    private String certAlias;
    private String certPassword;
    private String certKsPath;
    private String certKsFileName;

    public SystemConfig(String rootKsPath, String rootPasswd, String organizationUnit, String commonName, String certAlias, String certKsPath, String certPassword) {
        this(rootKsPath, rootPasswd);
        this.organizationUnit = organizationUnit;
        this.commonName = commonName;
        this.country = "CN";
        this.certAlias = certAlias;
        this.certKsPath = certKsPath.substring(0, certKsPath.lastIndexOf(File.separatorChar) + 1);
        this.certKsFileName = certKsPath.substring(certKsPath.lastIndexOf(File.separatorChar) + 1, certKsPath.length());
        this.certPassword = certPassword = CipherUtil.zeroSuffix(certPassword);
    }

    public SystemConfig(String rootKsPath, String rootPasswd) {
        rootPasswd = CipherUtil.zeroSuffix(rootPasswd);
        this.issuerdn = this.initIssuerdn();
        this.rootAlias = Msp.ROOT_ALIAS;
        this.rootPassword = rootPasswd;
        this.rootKsPath = rootKsPath.substring(0, rootKsPath.lastIndexOf(File.separatorChar) + 1);
        this.rootKsFileName = rootKsPath.substring(rootKsPath.lastIndexOf(File.separatorChar) + 1, rootKsPath.length());
        this.validTime = 36500;
        this.certAlias = Msp.ROOT_ALIAS;
    }

    private String initIssuerdn() {
        if (Msp.getType() == Msp.Type.RSA) {
            return this.RSA_ISSUERDN;
        }
        return this.SM_ISSUERDN;
    }

    public String getIssuerdn() {
        return this.issuerdn;
    }

    public void setIssuerdn(String issuerdn) {
        this.issuerdn = issuerdn;
    }

    public int getValidTime() {
        return this.validTime;
    }

    public void setValidTime(int validTime) {
        this.validTime = validTime;
    }

    public String getOrganizationUnit() {
        return this.organizationUnit;
    }

    public void setOrganizationUnit(String organizationUnit) {
        this.organizationUnit = organizationUnit;
    }

    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public String getCommonName() {
        return this.commonName;
    }

    public void setCommonName(String commonName) {
        this.commonName = commonName;
    }

    public X509Certificate[] getChain() {
        return this.chain;
    }

    public void setChain(X509Certificate[] chain) {
        this.chain = chain;
    }

    public String getCertAlias() {
        return this.certAlias;
    }

    public void setCertAlias(String certAlias) {
        this.certAlias = certAlias;
    }

    public String getRSA_ISSUERDN() {
        return this.RSA_ISSUERDN;
    }

    public void setRSA_ISSUERDN(String rSA_ISSUERDN) {
        this.RSA_ISSUERDN = rSA_ISSUERDN;
    }

    public String getSM_ISSUERDN() {
        return this.SM_ISSUERDN;
    }

    public void setSM_ISSUERDN(String sM_ISSUERDN) {
        this.SM_ISSUERDN = sM_ISSUERDN;
    }

    public String getRootAlias() {
        return this.rootAlias;
    }

    public void setRootAlias(String rootAlias) {
        this.rootAlias = rootAlias;
    }

    public String getRootPassword() {
        return this.rootPassword;
    }

    public void setRootPassword(String rootPassword) {
        this.rootPassword = rootPassword;
    }

    public String getRootKsPath() {
        return this.rootKsPath;
    }

    public void setRootKsPath(String rootKsPath) {
        this.rootKsPath = rootKsPath;
    }

    public String getRootKsFileName() {
        return this.rootKsFileName;
    }

    public void setRootKsFileName(String rootKsFileName) {
        this.rootKsFileName = rootKsFileName;
    }

    public String getCertPassword() {
        return this.certPassword;
    }

    public void setCertPassword(String certPassword) {
        this.certPassword = certPassword;
    }

    public String getCertKsPath() {
        return this.certKsPath;
    }

    public void setCertKsPath(String certKsPath) {
        this.certKsPath = certKsPath;
    }

    public String getCertKsFileName() {
        return this.certKsFileName;
    }

    public void setCertKsFileName(String certKsFileName) {
        this.certKsFileName = certKsFileName;
    }
}

