/*
 * Decompiled with CFR 0.152.
 */
package cn.tdchain.tdmsp;

import cn.tdchain.tdmsp.ca.config.SystemConfig;
import cn.tdchain.tdmsp.ca.config.TdMSPMsg;
import cn.tdchain.tdmsp.ca.root.RsaCertificate;
import cn.tdchain.tdmsp.manage.TdMSPIdentity;
import cn.tdchain.tdmsp.util.PkiUtil;
import java.io.ByteArrayInputStream;
import java.security.KeyStore;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Base64;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class Msp {
    public static String ROOT_ALIAS;
    public static String ORGANIZATION_ALIAS;
    public static String COMMON_NAME;
    private static Type type;

    public static void createRootCert(String rootKsPath, String rootPasswd) {
        if (type == Type.RSA) {
            RsaCertificate rsa = new RsaCertificate();
            rsa.creatRootCA(rootKsPath, rootPasswd);
        }
    }

    public static void createOrganizationUnitCert(String rootKsPath, String rootPasswd, String organizationUnit, String certKsPath, String certPassword) {
        if (type == Type.RSA) {
            RsaCertificate rsa = new RsaCertificate();
            SystemConfig keyStoreParam = new SystemConfig(rootKsPath, rootPasswd, organizationUnit, COMMON_NAME, ORGANIZATION_ALIAS, certKsPath, certPassword);
            rsa.creatOuCert(keyStoreParam);
        }
    }

    public static boolean validateCert(X509Certificate rootCert, X509Certificate cert) {
        TdMSPIdentity identity = new TdMSPIdentity();
        TdMSPMsg tdMSPMsg = identity.validateCert(rootCert, cert);
        return tdMSPMsg.getType() == 0;
    }

    public static KeyStore getKeyStore(String filePath, String ksPassword) {
        try {
            return PkiUtil.getKeyStore(filePath, ksPassword, "PKCS12");
        }
        catch (Exception e) {
            return null;
        }
    }

    public static X509Certificate getCert(String certPath) {
        try {
            return PkiUtil.getCertFromCer(certPath);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String certToBase64String(X509Certificate cert) {
        if (cert != null) {
            try {
                return Base64.getEncoder().encodeToString(cert.getEncoded());
            }
            catch (CertificateEncodingException e) {
                return null;
            }
        }
        return null;
    }

    public static X509Certificate base64StringToCert(String certBase64String) {
        if (certBase64String != null && certBase64String.length() > 0) {
            try {
                byte[] cert_b = Base64.getDecoder().decode(certBase64String);
                CertificateFactory cf = CertificateFactory.getInstance("X509", "BC");
                X509Certificate x509Cert = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(cert_b));
                return x509Cert;
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    public static void useRSA() {
        type = Type.RSA;
    }

    public static void useSM() {
        type = Type.SM;
    }

    public static Type getType() {
        return type;
    }

    public static String getOrganizationName(X509Certificate clientCert) {
        String subjectName = clientCert.getSubjectX500Principal().getName();
        subjectName = subjectName.split("OU=")[1];
        String substring = subjectName.substring(0, subjectName.indexOf(","));
        return substring;
    }

    public static void main(String[] args) throws Exception {
        Msp.useRSA();
        Msp.createOrganizationUnitCert("/Users/yaochuang/cer/test/rsa_tdbc_root.pfx", "123456", "user", "/Users/yaochuang/cer/test/rsa_user.pfx", "123456");
    }

    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
        ROOT_ALIAS = "root_ca_cert";
        ORGANIZATION_ALIAS = "org_ca_alias";
        COMMON_NAME = "td_common_name";
        type = Type.RSA;
    }

    public static enum Type {
        SM,
        RSA;

    }
}

