/*
 * Decompiled with CFR 0.152.
 */
package cn.tdchain.jbcc.rpc.nio.handler;

import cn.tdchain.cipher.DataCipher;
import cn.tdchain.cipher.utils.StringUtils;
import cn.tdchain.jbcc.net.nio.NioNet;
import cn.tdchain.jbcc.net.nio.NioResphone;
import cn.tdchain.jbcc.rpc.RPCResult;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class NioResponseClientHandler
extends ChannelInboundHandlerAdapter {
    private static final ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(4, 40, 10000L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
    private NioResphone nioResphone;
    private NioNet.NioTask task;

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        threadPoolExecutor.submit(() -> {
            String message = (String)msg;
            if (StringUtils.isBlank(message)) {
                return;
            }
            RPCResult r = (RPCResult)JSONObject.parseObject((String)message, RPCResult.class);
            if (r != null && r.getType() == RPCResult.ResultType.batch_resphone) {
                String cipher_data = r.getEntity();
                DataCipher data = (DataCipher)JSONObject.parseObject((String)cipher_data, DataCipher.class);
                String data_str = data.getData(this.nioResphone.getKey().getPrivateKey(), this.nioResphone.getCipher());
                if (data_str == null) {
                    return;
                }
                Map connectionMap = (Map)JSON.parseObject((String)data_str, (TypeReference)new TypeReference<Map<String, RPCResult>>(){}, (Feature[])new Feature[0]);
                if (connectionMap != null && connectionMap.size() > 0) {
                    this.nioResphone.getPool().add(connectionMap);
                }
            }
        });
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        if (this.task != null && !this.task.getRpcPool().isAlived()) {
            this.task.setStatus(false);
        }
        ctx.close();
    }

    public void exceptionCaught(ChannelHandlerContext context, Throwable cause) {
        cause.printStackTrace();
    }

    public NioResphone getNioResphone() {
        return this.nioResphone;
    }

    public void setNioResphone(NioResphone nioResphone) {
        this.nioResphone = nioResphone;
    }

    public NioNet.NioTask getTask() {
        return this.task;
    }

    public void setTask(NioNet.NioTask task) {
        this.task = task;
    }
}

